<?php
/**
 * @version $Id$
 * @author Thomas Crespin <thomas.crespin@sesamath.net>
 * @copyright Thomas Crespin 2009-2022
 * 
 * ****************************************************************************************************
 * SACoche <https://sacoche.sesamath.net> - Suivi d’Acquisitions de Compétences
 * © Thomas Crespin pour Sésamath <https://www.sesamath.net> - Tous droits réservés.
 * Logiciel placé sous la licence libre Affero GPL 3 <https://www.gnu.org/licenses/agpl-3.0.html>.
 * ****************************************************************************************************
 * 
 * Ce fichier est une partie de SACoche.
 * 
 * SACoche est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes 
 * de la “GNU Affero General Public License” telle que publiée par la Free Software Foundation :
 * soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.
 * 
 * SACoche est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE :
 * sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.
 * Consultez la Licence Publique Générale GNU Affero pour plus de détails.
 * 
 * Vous devriez avoir reçu une copie de la Licence Publique Générale GNU Affero avec SACoche ;
 * si ce n’est pas le cas, consultez : <http://www.gnu.org/licenses/>.
 * 
 */

if(!defined('SACoche')) {exit('Ce fichier ne peut être appelé directement !');}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2024-08-12 => 2025-05-14
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2024-08-12')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2025-05-14';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // ajout de paramètre dans [sacoche_officiel_configuration]
    // il faut aussi mettre à jour les archives des bilans officiels (même si ce nouveau paramètre n’y sera pas utilisé)
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_configuration SET configuration_contenu = REPLACE( configuration_contenu , "\\"assiduite\\"" , "\\"appreciation_rubrique_vide_cache\\":0,\\"assiduite\\"" ) WHERE officiel_type="bulletin" ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_officiel_archive SET archive_contenu = REPLACE( archive_contenu , "\\"BULLETIN_ASSIDUITE\\"" , "\\"BULLETIN_APPRECIATION_RUBRIQUE_VIDE_CACHE\\":0,\\"BULLETIN_ASSIDUITE\\"" ) WHERE archive_ref="bulletin" ' );
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2025-05-14 => 2025-05-16
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2025-05-14')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2025-05-16';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // modif champ sacoche_referentiel_item.item_coef
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_referentiel_item CHANGE item_coef item_coef FLOAT(4,2) UNSIGNED NOT NULL DEFAULT 1 ' );
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2025-05-16 => 2025-08-30
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2025-05-16')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2025-08-30';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // changement d’ENT
    // /!\ Il faut penser à modifier aussi la table webmestre si multi-structures
    // UPDATE sacoche_webmestre.sacoche_convention SET connexion_nom="kosmos_auvergne-rhone-alpes" WHERE connexion_nom = "kosmos_cybercolleges42" AND convention_date_debut >"2025-07-01";
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="kosmos_auvergne-rhone-alpes" WHERE parametre_nom="connexion_nom" AND parametre_valeur="kosmos_cybercolleges42" ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="cas.ent.auvergnerhonealpes.fr" WHERE parametre_nom="cas_serveur_host" AND parametre_valeur="cas.cybercolleges42.fr" ' );
    // modification sacoche_parametre (connecteur CAS pour ENT)
    $connexion_host = DB::queryOne(SACOCHE_STRUCTURE_BD_NAME , 'SELECT parametre_valeur FROM sacoche_parametre WHERE parametre_nom="cas_serveur_host"' );
    if($connexion_host=='ent.netocentre.fr')
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="auth.recia.fr" WHERE parametre_nom="cas_serveur_host" ' );
    }
    // changement d’ENT
    $connexion_nom = DB::queryOne(SACOCHE_STRUCTURE_BD_NAME , 'SELECT parametre_valeur FROM sacoche_parametre WHERE parametre_nom="connexion_nom"' );
    if($connexion_nom=='kosmos_aucollege84')
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="entlibre_aucollege84" WHERE parametre_nom="connexion_nom" ' );
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="www.aucollege84.vaucluse.fr" WHERE parametre_nom="cas_serveur_host" ' );
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="cas" WHERE parametre_nom="cas_serveur_root" ' );
    }
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2025-08-30 => 2025-09-04
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2025-08-30')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2025-09-04';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // renommage de connecteurs ENT
    // /!\ Il faut penser à modifier aussi la table webmestre si multi-structures
    /*
    UPDATE sacoche_webmestre.sacoche_convention SET connexion_nom="recia_chercan"          WHERE connexion_nom = "netocentre_chercan"          AND convention_date_debut >="2025-07-01";
    UPDATE sacoche_webmestre.sacoche_convention SET connexion_nom="recia_eureliens_28"     WHERE connexion_nom = "netocentre_eureliens_28"     AND convention_date_debut >="2025-07-01";
    UPDATE sacoche_webmestre.sacoche_convention SET connexion_nom="recia_mon-e-college_36" WHERE connexion_nom = "netocentre_mon-e-college_36" AND convention_date_debut >="2025-07-01";
    UPDATE sacoche_webmestre.sacoche_convention SET connexion_nom="recia_touraine-eschool" WHERE connexion_nom = "netocentre_touraine-eschool" AND convention_date_debut >="2025-07-01";
    UPDATE sacoche_webmestre.sacoche_convention SET connexion_nom="recia_colleges41"       WHERE connexion_nom = "netocentre_colleges41"       AND convention_date_debut >="2025-07-01";
    UPDATE sacoche_webmestre.sacoche_convention SET connexion_nom="recia_mon-e-college_45" WHERE connexion_nom = "netocentre_mon-e-college_45" AND convention_date_debut >="2025-07-01";
    */
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="recia_chercan"          WHERE parametre_nom="connexion_nom" AND parametre_valeur="netocentre_chercan" ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="recia_eureliens_28"     WHERE parametre_nom="connexion_nom" AND parametre_valeur="netocentre_eureliens_28" ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="recia_mon-e-college_36" WHERE parametre_nom="connexion_nom" AND parametre_valeur="netocentre_mon-e-college_36" ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="recia_touraine-eschool" WHERE parametre_nom="connexion_nom" AND parametre_valeur="netocentre_touraine-eschool" ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="recia_colleges41"       WHERE parametre_nom="connexion_nom" AND parametre_valeur="netocentre_colleges41" ' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="recia_mon-e-college_45" WHERE parametre_nom="connexion_nom" AND parametre_valeur="netocentre_mon-e-college_45" ' );
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2025-09-04 => 2025-09-18
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2025-09-04')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2025-09-18';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // MAJ modalités d'accompagnement
    if(empty($reload_sacoche_livret_modaccomp))
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'DELETE FROM sacoche_livret_modaccomp WHERE livret_modaccomp_code IN("CTR","RASED")' );
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'DELETE sacoche_livret_jointure_modaccomp_eleve, sacoche_livret_jointure_modaccomp_periode '
        . 'FROM sacoche_livret_jointure_modaccomp_eleve '
        . 'LEFT JOIN sacoche_livret_jointure_modaccomp_periode USING (livret_modaccomp_id) '
        . 'WHERE livret_modaccomp_code IN("CTR","RASED") ' );
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_livret_jointure_modaccomp_eleve CHANGE info_complement info_complement TEXT COLLATE utf8_unicode_ci NOT NULL COMMENT "Dans le cas où la modalité d’accompagnement est PPRE." ' );
    }
    if(empty($reload_sacoche_livret_page))
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_livret_page ADD livret_page_modaccomp TINYINT UNSIGNED NOT NULL DEFAULT 0 AFTER livret_page_ap' );
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_livret_page SET livret_page_modaccomp=livret_page_ap' );
    }
    // recharger [sacoche_livret_rubrique] (LSU 1D : modifications diverses de domaines et sous-domaines de la nomenclature 2.3 à 2.4...)
    if(empty($reload_sacoche_livret_rubrique))
    {
      $reload_sacoche_livret_rubrique = TRUE;
      $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_livret_rubrique.sql');
      DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
      DB::close(SACOCHE_STRUCTURE_BD_NAME);
    }
    // LSU 2D : positionnements des bilans périodiques des élèves de 3e maintenant obligatoirement en note sur 20
    // Remarque : on pourrait effectuer l’UPDATE sans tester la valeur antérieure car dans tous les cas cela devient imposé.
    $type_positionnement = DB::queryOne(SACOCHE_STRUCTURE_BD_NAME , 'SELECT livret_page_colonne FROM sacoche_livret_page WHERE livret_page_ref="3e"' );
    if(in_array($type_positionnement,array('pourcentage','position','objectif')))
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_livret_page SET livret_page_colonne="moyenne" WHERE livret_page_ref="3e"' );
    }
    // retrait d’un paramètre
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'DELETE FROM sacoche_parametre WHERE parametre_nom="droit_socle_prevision_points_brevet"' );
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2025-09-18 => 2025-09-24
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2025-09-18')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2025-09-24';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // modification sacoche_parametre (connecteur CAS pour ENT)
    $connexion_host = DB::queryOne(SACOCHE_STRUCTURE_BD_NAME , 'SELECT parametre_valeur FROM sacoche_parametre WHERE parametre_nom="cas_serveur_host"' );
    if($connexion_host=='ent.iledefrance.fr')
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="auth.monlycee.net" WHERE parametre_nom="cas_serveur_host" ' );
    }
    // suppression d’une table inutilisée
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'DROP TABLE IF EXISTS sacoche_livret_jointure_dnb_eleve' );
    // nouvelle table [sacoche_livret_dnb_mef]
    $reload_sacoche_livret_dnb_mef = TRUE;
    $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_livret_dnb_mef.sql');
    DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
    DB::close(SACOCHE_STRUCTURE_BD_NAME);
    // nouvelle table [sacoche_livret_dnb_matiere]
    $reload_sacoche_livret_dnb_matiere = TRUE;
    $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_livret_dnb_matiere.sql');
    DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
    DB::close(SACOCHE_STRUCTURE_BD_NAME);
    // nouvelle table [sacoche_livret_dnb_modalite_election]
    $reload_sacoche_livret_dnb_modalite_election = TRUE;
    $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_livret_dnb_modalite_election.sql');
    DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
    DB::close(SACOCHE_STRUCTURE_BD_NAME);
    // nouvelle table [sacoche_livret_dnb_jointure_mef_matiere]
    $reload_sacoche_livret_dnb_jointure_mef_matiere = TRUE;
    $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_livret_dnb_jointure_mef_matiere.sql');
    DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
    DB::close(SACOCHE_STRUCTURE_BD_NAME);
    // L’ajout de matières cause des conflits lorsque matiere_ref est déjà pris par une matière spécifique.
    // Il s’avère plus stratégique de 
    // 1) récupérer les matières spécifiques et les matières partagées utilisées
    // 2) recharger toute la table des matières partagées
    // 3) recréer ou convertir les matières spécifiques et réactiver les matières partagées utilisées
    // PS. On laisse tomber toutes les matières en doublon "option", "hors établissement", "par correspondance"...
    // Go :
    // récupération des informations sur les matières
    $DB_TAB_communes    = DB::queryTab(SACOCHE_STRUCTURE_BD_NAME , 'SELECT * FROM sacoche_matiere WHERE (matiere_active=1 OR matiere_siecle=1) AND matiere_id<='.ID_MATIERE_PARTAGEE_MAX);
    $DB_TAB_specifiques = DB::queryTab(SACOCHE_STRUCTURE_BD_NAME , 'SELECT * FROM sacoche_matiere WHERE matiere_id>'.ID_MATIERE_PARTAGEE_MAX);
    if(empty($reload_sacoche_matiere))
    {
      // rechargement de la table sacoche_matiere
      $reload_sacoche_matiere = TRUE;
      $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_matiere.sql');
      DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
      DB::close(SACOCHE_STRUCTURE_BD_NAME);
    }
    // on remet en place les matières partagées
    foreach($DB_TAB_communes as $DB_ROW)
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_matiere SET matiere_active='.$DB_ROW['matiere_active'].', matiere_siecle='.$DB_ROW['matiere_siecle'].', matiere_nb_demandes='.$DB_ROW['matiere_nb_demandes'].', matiere_ordre='.$DB_ROW['matiere_ordre'].' WHERE matiere_id='.$DB_ROW['matiere_id'] );
    }
    // on remet en place les matières spécifiques
    foreach($DB_TAB_specifiques as $DB_ROW)
    {
      $DB_VAR = array( ':matiere_ref' => $DB_ROW['matiere_ref'] );
      $matiere_id_partage = DB::queryOne(SACOCHE_STRUCTURE_BD_NAME , 'SELECT matiere_id FROM sacoche_matiere WHERE matiere_ref=:matiere_ref LIMIT 1' , $DB_VAR);
      if(!$matiere_id_partage)
      {
        // Pas de conflit : on remet la matière spécifique telle qu’elle était
        $DB_SQL = 'INSERT INTO sacoche_matiere( matiere_id, matiere_active, matiere_siecle, matiere_usuelle, matiere_famille_id, matiere_nb_demandes, matiere_ordre, matiere_code, matiere_ref, matiere_nom) '
                . 'VALUES                     (:matiere_id,:matiere_active,:matiere_siecle,:matiere_usuelle,:matiere_famille_id,:matiere_nb_demandes,:matiere_ordre,:matiere_code,:matiere_ref,:matiere_nom) ';
        $DB_VAR = array(
          ':matiere_id'          => $DB_ROW['matiere_id'],
          ':matiere_active'      => $DB_ROW['matiere_active'],
          ':matiere_siecle'      => $DB_ROW['matiere_siecle'],
          ':matiere_usuelle'     => 0,
          ':matiere_famille_id'  => 0,
          ':matiere_nb_demandes' => $DB_ROW['matiere_nb_demandes'],
          ':matiere_ordre'       => $DB_ROW['matiere_ordre'],
          ':matiere_code'        => $DB_ROW['matiere_code'],
          ':matiere_ref'         => $DB_ROW['matiere_ref'],
          ':matiere_nom'         => $DB_ROW['matiere_nom'],
        );
        DB::query(SACOCHE_STRUCTURE_BD_NAME , $DB_SQL , $DB_VAR);
      }
      else
      {
        // Conflit : on la convertit en matière partagée
        DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_matiere SET matiere_active=1, matiere_nb_demandes='.$DB_ROW['matiere_nb_demandes'].', matiere_ordre='.$DB_ROW['matiere_ordre'].' WHERE matiere_id='.$matiere_id_partage );
        DB_STRUCTURE_MATIERE::DB_deplacer_referentiel_matiere( $DB_ROW['matiere_id'] , $matiere_id_partage );
      }
    }
    // Pour l’ajout ou la modification de niveaux, comme pour les matières, 
    // plutôt que de lister toutes les différences il est plus aisé de :
    // 1) récupérer les niveaux spécifiques et les niveaux partagés utilisés
    // 2) recharger toute la table des niveaux partagés
    // 3) recréer ou convertir les niveaux spécifiques et réactiver les niveaux partagés utilisés
    // Go :
    // mémoriser les niveaux spécifiques et les niveaux actifs
    $DB_SQL = 'SELECT niveau_id FROM sacoche_niveau WHERE niveau_actif = 1 AND niveau_id <= '.ID_NIVEAU_PARTAGE_MAX;
    $DB_COL_actifs = DB::queryCol(SACOCHE_STRUCTURE_BD_NAME , $DB_SQL);
    $DB_SQL = 'SELECT niveau_id , niveau_ref , niveau_nom FROM sacoche_niveau WHERE niveau_id > '.ID_NIVEAU_PARTAGE_MAX;
    $DB_TAB_persos = DB::queryTab(SACOCHE_STRUCTURE_BD_NAME , $DB_SQL);
    if(empty($reload_sacoche_niveau_famille))
    {
      //  rechargement de la table niveau_famille
      $reload_sacoche_niveau_famille = TRUE;
      $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_niveau_famille.sql');
      DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
      DB::close(SACOCHE_STRUCTURE_BD_NAME);
    }
    if(empty($reload_sacoche_niveau))
    {
      //  rechargement de la table niveau
      $reload_sacoche_niveau = TRUE;
      $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_niveau.sql');
      DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
      DB::close(SACOCHE_STRUCTURE_BD_NAME);
    }
    // remise en place des niveaux actifs
    if(!empty($DB_COL_actifs))
    {
      foreach($DB_COL_actifs as $niveau_id)
      {
        DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_niveau SET niveau_actif = 1 WHERE niveau_id = '.$niveau_id );
      }
    }
    // remise en place des niveaux spécifiques
    if(!empty($DB_TAB_persos))
    {
      $DB_SQL = 'INSERT INTO sacoche_niveau( niveau_id, niveau_actif, niveau_usuel, niveau_famille_id, niveau_ordre, niveau_ref, code_mef, niveau_nom) '
              . 'VALUES                    (:niveau_id,:niveau_actif,:niveau_usuel,:niveau_famille_id,:niveau_ordre,:niveau_ref,:code_mef,:niveau_nom) ';
      foreach($DB_TAB_persos as $DB_ROW)
      {
        $DB_VAR = array(
          ':niveau_id'         => $DB_ROW['niveau_id'],
          ':niveau_actif'      => 1,
          ':niveau_usuel'      => 0,
          ':niveau_famille_id' => 0,
          ':niveau_ordre'      => 999,
          ':niveau_ref'        => $DB_ROW['niveau_ref'],
          ':code_mef'          => '',
          ':niveau_nom'        => $DB_ROW['niveau_nom'],
        );
        DB::query(SACOCHE_STRUCTURE_BD_NAME , $DB_SQL , $DB_VAR);
      }
    }
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2025-09-24 => 2025-09-27
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2025-09-24')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2025-09-27';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // ajout méthode de calcul
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_referentiel CHANGE referentiel_calcul_methode referentiel_calcul_methode ENUM("geometrique","arithmetique","classique","bestof1","bestof2","bestof3","frequencemin","frequencemax","somme") CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT "geometrique" COMMENT "Coefficients en progression géométrique, arithmetique, ou moyenne classique non pondérée, ou conservation des meilleurs scores, ou de la plus fréquente, ou cumul des réussites. Valeur surclassant la configuration par défaut." ' );
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2025-09-27 => 2025-10-03
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2025-09-27')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2025-10-03';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    if(empty($reload_sacoche_livret_dnb_matiere))
    {
      // erreur détectée dans les spécifications fournies pour la matière SVT, et autre bricoles de nommage
      $reload_sacoche_livret_dnb_matiere = TRUE;
      $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_livret_dnb_matiere.sql');
      DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
      DB::close(SACOCHE_STRUCTURE_BD_NAME);
    }
    // ajout de la colonne eleve_dnb_mef_id à la table [sacoche_user]
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_user ADD eleve_dnb_mef_id TINYINT UNSIGNED NOT NULL DEFAULT 0 COMMENT "Niveau de formation pour le livret scolaire (élèves de 3e uniquement)." AFTER eleve_lv2' );
    // et initialisation de valeurs SIECLE si un import est disponible
    $tab_mef_3e = array();
    $DB_TAB = DB_STRUCTURE_SIECLE::DB_lister_dnb_mef_code();
    foreach($DB_TAB as $DB_ROW)
    {
      $tab_mef_3e[$DB_ROW['livret_dnb_mef_code']] = $DB_ROW['livret_dnb_mef_id'];
    }
    $tab_SIECLE = DB_STRUCTURE_SIECLE::DB_recuperer_import_contenu('Eleves');
    if(!empty($tab_SIECLE))
    {
      if(!empty($tab_SIECLE['DONNEES']['ELEVES']['ELEVE']))
      {
        foreach($tab_SIECLE['DONNEES']['ELEVES']['ELEVE'] as $tab)
        {
          if( isset($tab['CODE_MEF']) )
          {
            $sconet_id = $tab['@attributes']['ELEVE_ID'];
            $eleve_mef = $tab['CODE_MEF'];
            if($eleve_mef)
            {
              foreach($tab_mef_3e as $masque_recherche => $dnb_mef_id)
              {
                if(preg_match('/^'.$masque_recherche.'$/',$eleve_mef))
                {
                  $DB_VAR = array(
                    ':sconet_id'  => $sconet_id,
                    ':dnb_mef_id' => $dnb_mef_id,
                  );
                  DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_user SET eleve_dnb_mef_id=:dnb_mef_id WHERE user_sconet_id=:sconet_id' , $DB_VAR );
                  break;
                }
              }
            }
          }
        }
      }
    }
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2025-10-03 => 2025-10-10
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2025-10-03')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2025-10-10';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // modification sacoche_parametre (connecteur CAS pour ENT)
    $connexion_host = DB::queryOne(SACOCHE_STRUCTURE_BD_NAME , 'SELECT parametre_valeur FROM sacoche_parametre WHERE parametre_nom="cas_serveur_host"' );
    if($connexion_host=='auth.monlycee.net')
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="ent.monlycee.net" WHERE parametre_nom="cas_serveur_host" ' );
    }
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2025-10-10 => 2025-10-24
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2025-10-10')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2025-10-24';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // modification colonnes de [sacoche_courriel_erreur]
    if(empty($reload_sacoche_courriel_erreur))
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_courriel_erreur CHANGE erreur_users erreur_users VARCHAR(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT "" ' );
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_courriel_erreur CHANGE erreur_info  erreur_info  TEXT         COLLATE utf8_unicode_ci          DEFAULT NULL ' );
    }
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2025-10-24 => 2025-10-28
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2025-10-24')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2025-10-28';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // suppression de 4 tables
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'DROP TABLE IF EXISTS sacoche_livret_enscompl' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'DROP TABLE IF EXISTS sacoche_livret_jointure_enscompl_eleve' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'DROP TABLE IF EXISTS sacoche_livret_element_cycle' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'DROP TABLE IF EXISTS sacoche_livret_element_niveau' );
    // rechargement de 3 tables
    if(empty($reload_sacoche_livret_element_domaine))
    {
      $reload_sacoche_livret_element_domaine = TRUE;
      $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_livret_element_domaine.sql');
      DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
      DB::close(SACOCHE_STRUCTURE_BD_NAME);
    }
    if(empty($reload_sacoche_livret_element_theme))
    {
      $reload_sacoche_livret_element_theme = TRUE;
      $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_livret_element_theme.sql');
      DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
      DB::close(SACOCHE_STRUCTURE_BD_NAME);
    }
    if(empty($reload_sacoche_livret_element_item))
    {
      $reload_sacoche_livret_element_item = TRUE;
      $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_livret_element_item.sql');
      DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
      DB::close(SACOCHE_STRUCTURE_BD_NAME);
    }
    // retrait de paramètres
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'DELETE FROM sacoche_parametre WHERE parametre_nom="droit_gerer_livret_enscompl"' );
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'DELETE FROM sacoche_parametre WHERE parametre_nom="droit_officiel_livret_positionner_enscompl"' );
    // modif colonnes table [sacoche_livret_saisie]
    if(empty($reload_sacoche_livret_saisie))
    {
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_livret_saisie CHANGE rubrique_type rubrique_type VARCHAR(14) COLLATE utf8_unicode_ci NOT NULL DEFAULT "" COMMENT "eval | socle | ap | epi | parcours | viesco | bilan | langcultregion | attitude" ' );
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'ALTER TABLE sacoche_livret_saisie CHANGE rubrique_id rubrique_id SMALLINT UNSIGNED NOT NULL DEFAULT 0 COMMENT "livret_rubrique_id | socle_composante (11;12;13;14;20;30;40;50) | 0 pour viesco | bilan" ' );
    }
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2025-10-28 => 2025-10-31
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2025-10-28')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2025-10-31';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    // rechargement de la table [sacoche_livret_epi_theme] si elle est ne contient pas les thèmes officiels (il y avait une erreur dans la requête de remplissage depuis... 2017 !!!)
    $nb_epi_national = DB::queryOne(SACOCHE_STRUCTURE_BD_NAME , 'SELECT COUNT(livret_epi_theme_code) FROM sacoche_livret_epi_theme WHERE livret_epi_theme_origine=1' );
    if(!$nb_epi_national)
    {
      $nb_epi_perso = DB::queryOne(SACOCHE_STRUCTURE_BD_NAME , 'SELECT COUNT(livret_epi_theme_code) FROM sacoche_livret_epi_theme WHERE livret_epi_theme_origine=2' );
      // récupération des informations sur les thèmes des EPI persos
      if($nb_epi_perso)
      {
        $DB_TAB = DB::queryTab(SACOCHE_STRUCTURE_BD_NAME , 'SELECT * FROM sacoche_livret_epi_theme WHERE livret_epi_theme_origine=2' );
      }
      // rechargement de la table sacoche_livret_epi_theme
      $reload_sacoche_livret_epi_theme = TRUE;
      $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_livret_epi_theme.sql');
      DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
      DB::close(SACOCHE_STRUCTURE_BD_NAME);
      // on remet en place les EPI persos
      if($nb_epi_perso)
      {
        $DB_SQL = 'INSERT INTO sacoche_livret_epi_theme( livret_epi_theme_code, livret_epi_theme_origine, livret_epi_theme_nom) '
                . 'VALUES                              (:livret_epi_theme_code,:livret_epi_theme_origine,:livret_epi_theme_nom) '
                . 'ON DUPLICATE KEY UPDATE livret_epi_theme_origine=livret_epi_theme_origine ';
        foreach($DB_TAB as $DB_ROW)
        {
          $DB_VAR = array(
            ':livret_epi_theme_code' => $DB_ROW['livret_epi_theme_code'],
            ':livret_epi_theme_origine' => 2,
            ':livret_epi_theme_nom' => $DB_ROW['livret_epi_theme_nom'],
          );
          DB::query(SACOCHE_STRUCTURE_BD_NAME , $DB_SQL , $DB_VAR);
        }
      }
    }
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2025-10-31 => 2025-11-03
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2025-10-31')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2025-11-03';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    if(empty($reload_sacoche_livret_dnb_matiere))
    {
      // erreur sur la possibilité de dispense d’une matière
      $reload_sacoche_livret_dnb_matiere = TRUE;
      $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_livret_dnb_matiere.sql');
      DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
      DB::close(SACOCHE_STRUCTURE_BD_NAME);
    }
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// MAJ 2025-11-03 => 2025-11-20
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($version_base_structure_actuelle=='2025-11-03')
{
  if($version_base_structure_actuelle==DB_STRUCTURE_MAJ_BASE::DB_version_base())
  {
    $version_base_structure_actuelle = '2025-11-20';
    DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_parametre SET parametre_valeur="'.$version_base_structure_actuelle.'" WHERE parametre_nom="version_base"' );
    if(empty($reload_sacoche_matiere_famille))
    {
      // Retrait d’une famille de matières
      DB::query(SACOCHE_STRUCTURE_BD_NAME , 'DELETE FROM sacoche_matiere_famille WHERE matiere_famille_id = 93 ' );
    }
    // L’ajout de matières cause des conflits lorsque matiere_ref est déjà pris par une matière spécifique.
    // Il s’avère plus stratégique de 
    // 1) récupérer les matières spécifiques et les matières partagées utilisées
    // 2) recharger toute la table des matières partagées
    // 3) recréer ou convertir les matières spécifiques et réactiver les matières partagées utilisées
    // PS. On laisse tomber toutes les matières en doublon "option", "hors établissement", "par correspondance"...
    // Go :
    // récupération des informations sur les matières
    $DB_TAB_communes    = DB::queryTab(SACOCHE_STRUCTURE_BD_NAME , 'SELECT * FROM sacoche_matiere WHERE (matiere_active=1 OR matiere_siecle=1) AND matiere_id<='.ID_MATIERE_PARTAGEE_MAX);
    $DB_TAB_specifiques = DB::queryTab(SACOCHE_STRUCTURE_BD_NAME , 'SELECT * FROM sacoche_matiere WHERE matiere_id>'.ID_MATIERE_PARTAGEE_MAX);
    if(empty($reload_sacoche_matiere))
    {
      // rechargement de la table sacoche_matiere
      $reload_sacoche_matiere = TRUE;
      $requetes = file_get_contents(CHEMIN_DOSSIER_SQL_STRUCTURE.'sacoche_matiere.sql');
      DB::query(SACOCHE_STRUCTURE_BD_NAME , $requetes );
      DB::close(SACOCHE_STRUCTURE_BD_NAME);
    }
    // on remet en place les matières spécifiques
    $id_matiere_specifique_max = ID_MATIERE_PARTAGEE_MAX ;
    foreach($DB_TAB_specifiques as $DB_ROW)
    {
      $DB_VAR = array( ':matiere_ref' => $DB_ROW['matiere_ref'] );
      $matiere_id_partage = DB::queryOne(SACOCHE_STRUCTURE_BD_NAME , 'SELECT matiere_id FROM sacoche_matiere WHERE matiere_ref=:matiere_ref LIMIT 1' , $DB_VAR);
      if(!$matiere_id_partage)
      {
        $id_matiere_specifique_max = max( $id_matiere_specifique_max, $DB_ROW['matiere_id']);
        // Pas de conflit : on remet la matière spécifique telle qu’elle était
        $DB_SQL = 'INSERT INTO sacoche_matiere( matiere_id, matiere_active, matiere_experimentale, matiere_siecle, matiere_usuelle, matiere_famille_id, matiere_nb_demandes, matiere_ordre, matiere_code, matiere_ref, matiere_nom) '
                . 'VALUES                     (:matiere_id,:matiere_active,:matiere_experimentale,:matiere_siecle,:matiere_usuelle,:matiere_famille_id,:matiere_nb_demandes,:matiere_ordre,:matiere_code,:matiere_ref,:matiere_nom) ';
        $DB_VAR = array(
          ':matiere_id'           => $DB_ROW['matiere_id'],
          ':matiere_active'       => $DB_ROW['matiere_active'],
          ':matiere_experimentale'=> $DB_ROW['matiere_experimentale'],
          ':matiere_siecle'       => $DB_ROW['matiere_siecle'],
          ':matiere_usuelle'      => 0,
          ':matiere_famille_id'   => 0,
          ':matiere_nb_demandes'  => $DB_ROW['matiere_nb_demandes'],
          ':matiere_ordre'        => $DB_ROW['matiere_ordre'],
          ':matiere_code'         => $DB_ROW['matiere_code'],
          ':matiere_ref'          => $DB_ROW['matiere_ref'],
          ':matiere_nom'          => $DB_ROW['matiere_nom'],
        );
        DB::query(SACOCHE_STRUCTURE_BD_NAME , $DB_SQL , $DB_VAR);
      }
      else
      {
        // Conflit : on la convertit en matière partagée
        DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_matiere SET matiere_active='.$DB_ROW['matiere_active'].', matiere_experimentale='.$DB_ROW['matiere_experimentale'].', matiere_siecle='.$DB_ROW['matiere_siecle'].', matiere_nb_demandes='.$DB_ROW['matiere_nb_demandes'].', matiere_ordre='.$DB_ROW['matiere_ordre'].' WHERE matiere_id='.$matiere_id_partage );
        DB_STRUCTURE_MATIERE::DB_deplacer_referentiel_matiere( $DB_ROW['matiere_id'] , $matiere_id_partage );
      }
    }
    // on remet en place les matières partagées
    // Pour cette fois-ci il y a aussi des matières à déplacer.
    $tab_move = array(9307=>8070, 9308=>8080, 9315=>8150, 9316=>8160, 9318=>8180, 9319=>8190, 9320=>8200, 9321=>8210, 9322=>8220, 9323=>8230, 9325=>8250, 9326=>8260, 9327=>8270, 9328=>8280, 9330=>8300, 9331=>8310, 9332=>8320, 9333=>8330, 9334=>8349, 9335=>8350, 9336=>8360, 9337=>8370, 9338=>8380, 9339=>8390, 9391=>8391, 9392=>8392, 9393=>8393, 9394=>8394, 9395=>8399, 9396=>8399, 9397=>8398, 9340=>8400, 9341=>8410, 9342=>8420, 9343=>8430, 9344=>8440, 9345=>8450, 9346=>8460, 9347=>8470, 9348=>8480, 9350=>8500, 9351=>8510, 9352=>8520, 9353=>8530, 9354=>8540, 9355=>8550, 9356=>8560, 9357=>8587, 9358=>8580, 9359=>8590, 9360=>8600, 9361=>8610, 9362=>8620, 9363=>8630, 9364=>8640, 9367=>8670, 9368=>8680, 9369=>8690, 9370=>8700, 9371=>8710, 9372=>8720, 9373=>8730, 9374=>8880, 9380=>8800, 9381=>8810, 9382=>8820, 93=>8807, 375=>387, 376=>388, 377=>389, 378=>390, 379=>391, 380=>392, 381=>393, 382=>394, 383=>395, 384=>396, 385=>397, 386=>398);
    $tab_del = array(9317,9324);
    foreach($DB_TAB_communes as $DB_ROW)
    {
      if(isset($tab_move[$DB_ROW['matiere_id']]))
      {
        $matiere_id_new = $tab_move[$DB_ROW['matiere_id']];
        DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_matiere SET matiere_active='.$DB_ROW['matiere_active'].', matiere_experimentale='.$DB_ROW['matiere_experimentale'].', matiere_siecle='.$DB_ROW['matiere_siecle'].', matiere_nb_demandes='.$DB_ROW['matiere_nb_demandes'].', matiere_ordre='.$DB_ROW['matiere_ordre'].' WHERE matiere_id='.$matiere_id_new );
        DB_STRUCTURE_MATIERE::DB_deplacer_referentiel_matiere( $DB_ROW['matiere_id'] , $matiere_id_new );
      }
      else if(isset($tab_del[$DB_ROW['matiere_id']]))
      {
        // on la convertit en matière spécifique
        $id_matiere_specifique_max++;
        $DB_SQL = 'INSERT INTO sacoche_matiere( matiere_id, matiere_active, matiere_experimentale, matiere_siecle, matiere_usuelle, matiere_famille_id, matiere_nb_demandes, matiere_ordre, matiere_code, matiere_ref, matiere_nom) '
                . 'VALUES                     (:matiere_id,:matiere_active,:matiere_experimentale,:matiere_siecle,:matiere_usuelle,:matiere_famille_id,:matiere_nb_demandes,:matiere_ordre,:matiere_code,:matiere_ref,:matiere_nom) ';
        $DB_VAR = array(
          ':matiere_id'           => $id_matiere_specifique_max,
          ':matiere_active'       => $DB_ROW['matiere_active'],
          ':matiere_experimentale'=> $DB_ROW['matiere_experimentale'],
          ':matiere_siecle'       => $DB_ROW['matiere_siecle'],
          ':matiere_usuelle'      => 0,
          ':matiere_famille_id'   => 0,
          ':matiere_nb_demandes'  => $DB_ROW['matiere_nb_demandes'],
          ':matiere_ordre'        => $DB_ROW['matiere_ordre'],
          ':matiere_code'         => $DB_ROW['matiere_code'],
          ':matiere_ref'          => $DB_ROW['matiere_ref'],
          ':matiere_nom'          => $DB_ROW['matiere_nom'],
        );
        DB::query(SACOCHE_STRUCTURE_BD_NAME , $DB_SQL , $DB_VAR);
        DB_STRUCTURE_MATIERE::DB_deplacer_referentiel_matiere( $DB_ROW['matiere_id'] , $id_matiere_specifique_max );
      }
      else
      {
        DB::query(SACOCHE_STRUCTURE_BD_NAME , 'UPDATE sacoche_matiere SET matiere_active='.$DB_ROW['matiere_active'].', matiere_experimentale='.$DB_ROW['matiere_experimentale'].', matiere_siecle='.$DB_ROW['matiere_siecle'].', matiere_nb_demandes='.$DB_ROW['matiere_nb_demandes'].', matiere_ordre='.$DB_ROW['matiere_ordre'].' WHERE matiere_id='.$DB_ROW['matiere_id'] );
      }
    }
  }
}
// ////////////////////////////////////////////////////////////////////////////////////////////////////
// NE PAS OUBLIER de modifier aussi le nécessaire dans ./_sql/structure/ en fonction des évolutions !!!
// ////////////////////////////////////////////////////////////////////////////////////////////////////

// ///////////////////////////////////////////////////////////////////////////////////////////////////////
// NE PAS OUBLIER de maj les 2 tables de la base sacoche_projet en cas modif de matières ou de niveaux !!!
// ///////////////////////////////////////////////////////////////////////////////////////////////////////

?>
