DROP TABLE IF EXISTS sacoche_livret_dnb_matiere;

CREATE TABLE sacoche_livret_dnb_matiere (
  livret_dnb_matiere_id                TINYINT     UNSIGNED                NOT NULL,
  livret_dnb_matiere_code              CHAR(6)     COLLATE utf8_unicode_ci NOT NULL DEFAULT "" COMMENT "Masque à comparer avec <CODE_MATIERE> issu de SIECLE.",
  livret_dnb_modalite_election_code    CHAR(1)     COLLATE utf8_unicode_ci NOT NULL DEFAULT "" COMMENT "<CODE_MODALITE_ELECT> issu de SIECLE.",
  livret_dnb_matiere_obligatoire       TINYINT     UNSIGNED                NOT NULL DEFAULT 1,
  livret_dnb_matiere_dispense_possible TINYINT     UNSIGNED                NOT NULL DEFAULT 0,
  livret_dnb_matiere_nom               VARCHAR(70) COLLATE utf8_unicode_ci NOT NULL DEFAULT "",
  PRIMARY KEY (livret_dnb_matiere_id)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE sacoche_livret_dnb_matiere DISABLE KEYS;

INSERT INTO sacoche_livret_dnb_matiere VALUE
-- enseignements obligatoires
( 1, "020700", "S", 1, 0, "Français"),
( 2, "061300", "S", 1, 0, "Mathématiques"),
( 3, "043700", "S", 1, 0, "Histoire-géographie"),
( 4, "042100", "S", 1, 0, "Histoire-géographie et EMC"),
( 5, "03..01", "O", 1, 0, "Langue vivante 1"),
( 6, "03..02", "O", 1, 1, "Langue vivante 2"),
( 7, "043800", "S", 1, 0, "Enseignement moral et civique"),
( 8, "062900", "S", 1, 0, "Sciences de la vie et de la terre"),
( 9, "062300", "S", 1, 0, "Physique-chimie"),
(10, "070800", "S", 1, 0, "Technologie"),
(11, "090100", "S", 1, 0, "Arts plastiques"),
(12, "081300", "S", 1, 0, "Éducation musicale"),
(13, "081000", "S", 1, 0, "Éducation musicale générale et technique"),
(14, "100100", "S", 1, 1, "Éducation physique et sportive"),
(15, "023600", "F", 1, 0, "Langue et littérature"),
(16, "073800", "S", 1, 0, "Sciences et technologie"),
(17, "071100", "S", 1, 0, "Enseignement technologique professionnel"),
(18, "007400", "S", 1, 0, "Découverte professionnelle"),
(19, "083400", "S", 1, 0, "Enseignement artistique"),
(20, "304500", "S", 1, 0, "Biologie-écologie"),
(21, "412400", "S", 1, 0, "Technologie informatique et de communication"),
(22, "000500", "S", 1, 0, "Éducation socioculturelle"),
(23, "001300", "S", 1, 0, "Pratiques professionnelles"),
-- enseignements facultatifs
(24, "084300", "F", 0, 0, "Chant choral collectif"),
(25, "03..08", "F", 0, 0, "Langues et culture étrangère ou régionale"),
(26, "020300", "F", 0, 0, "Langues et cultures de l’antiquité - Latin"),
(27, "020400", "F", 0, 0, "Langues et cultures de l’antiquité - Grec"),
(28, "024000", "F", 0, 0, "Langues et cultures de l'antiquité - Latin Grec"),
(29, "005300", "F", 0, 0, "Langue des signes française"),
(30, "03..02", "F", 0, 0, "Langue vivante 2"),
(31, "......", "D", 0, 0, "Discipline Non Linguistique");

ALTER TABLE sacoche_livret_dnb_matiere ENABLE KEYS;
