<?php
/**
 * @version $Id$
 * @author Thomas Crespin <thomas.crespin@sesamath.net>
 * @copyright Thomas Crespin 2009-2022
 * 
 * ****************************************************************************************************
 * SACoche <https://sacoche.sesamath.net> - Suivi d’Acquisitions de Compétences
 * © Thomas Crespin pour Sésamath <https://www.sesamath.net> - Tous droits réservés.
 * Logiciel placé sous la licence libre Affero GPL 3 <https://www.gnu.org/licenses/agpl-3.0.html>.
 * ****************************************************************************************************
 * 
 * Ce fichier est une partie de SACoche.
 * 
 * SACoche est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes 
 * de la “GNU Affero General Public License” telle que publiée par la Free Software Foundation :
 * soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.
 * 
 * SACoche est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE :
 * sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.
 * Consultez la Licence Publique Générale GNU Affero pour plus de détails.
 * 
 * Vous devriez avoir reçu une copie de la Licence Publique Générale GNU Affero avec SACoche ;
 * si ce n’est pas le cas, consultez : <http://www.gnu.org/licenses/>.
 * 
 */

if(!defined('SACoche')) {exit('Ce fichier ne peut être appelé directement !');}
$TITRE = html(Lang::_('Déplacer les référentiels d’une matière vers une autre'));

// Lister les matières de l’établissement
$DB_TAB = DB_STRUCTURE_MATIERE::DB_lister_matieres_etablissement( TRUE /*order_by_name*/ , FALSE /*without_experimentale*/ );
$matieres_options = '<option value="0">&nbsp;</option>';
foreach($DB_TAB as $DB_ROW)
{
  $matieres_options .= '<option value="'.$DB_ROW['matiere_id'].'">'.html($DB_ROW['matiere_nom'].' ('.$DB_ROW['matiere_ref'].')').'</option>' ;
}
?>

<div><span class="manuel"><a class="pop_up" href="<?php echo SERVEUR_DOCUMENTAIRE ?>?fichier=support_administrateur__gestion_matieres#toggle_deplacer_referentiels">DOC : Déplacer les référentiels d’une matière vers une autre</a></span></div>

<hr>

<p class="danger">Cette opération n’est pas anodine : il est recommandé de l’effectuer en période creuse et de sauvegarder la base avant.</p>

<form action="#" method="post" id="form_move">
  <div>
    <label class="tab" for="f_matiere_avant">Ancienne matière :</label><select id="f_matiere_avant" name="f_matiere_avant"><?php echo $matieres_options ?></select><br>
    <label class="tab" for="f_matiere_apres">Nouvelle matière :</label><select id="f_matiere_apres" name="f_matiere_apres"><?php echo $matieres_options ?></select>
  </div>
  <p>
    <span class="tab"></span><button id="deplacer_referentiels" type="button" class="parametre">Déplacer les référentiels.</button><label id="ajax_msg_move">&nbsp;</label>
  </p>
</form>

<p>&nbsp;</p>
