DROP TABLE IF EXISTS sacoche_livret_dnb_mef;

CREATE TABLE sacoche_livret_dnb_mef (
  livret_dnb_mef_id              TINYINT     UNSIGNED                NOT NULL,
  livret_dnb_mef_code            CHAR(11)    COLLATE utf8_unicode_ci NOT NULL DEFAULT "" COMMENT "Masque à comparer avec le code_mef issu de SIECLE.",
  livret_dnb_mef_dnl_obligatoire TINYINT     UNSIGNED                NOT NULL DEFAULT 0,
  livret_dnb_mef_intitule        VARCHAR(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT "",
  PRIMARY KEY (livret_dnb_mef_id)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE sacoche_livret_dnb_mef DISABLE KEYS;

-- Il n’y a que 7 MEF nationaux (id 1 à 7 ci-dessous).

-- Pour tous les autres, on considère le MEF national de rattachement.
-- Par exemple :
-- 10310019113 = 3e section bilingue régionale
-- 10310019116 = 3e section excellence sportive (sport études)
-- 10310019117 = 3e section sportive scolaire
-- 1031001911U = 3e ULIS
-- 1031001911F = 3e UPE2A
-- 1031001911A = 3e académique
-- 1031000G11A = 3e cinéma-audiovisuel (exemple parmi d’autres de déclinaison académique)
-- Toutes ces formations sont rattachées au MEF 3e générique (avec les mêmes matières principales attendues au DNB)

-- On traite à part l’exception de la 3e section internationale à cause de la DNL obligatoire à gérer
-- La DNL n’est obligatoire que pour le MEF de 3e section internationale, et pas pour le MEF de 3e bilingue régionale contrairement à ce qui était noté dans les versions précédentes.


INSERT INTO sacoche_livret_dnb_mef VALUES 
( 1, "10310019110", 0, "3e"),
( 2, "1031002211.", 0, "3e danse"),
( 3, "1031000211.", 0, "3e musique"),
( 4, "1031002311.", 0, "3e théâtre"),
( 5, "1671000211.", 0, "3e SEGPA"),
( 6, "1031003111.", 0, "3e prépa-métiers"),
( 7, "1031002111.", 0, "3e de l’enseignement agricole"),
( 8, "10310019111", 1, "3e section internationale");

ALTER TABLE sacoche_livret_dnb_mef ENABLE KEYS;
