DROP TABLE IF EXISTS sacoche_livret_element_item;

CREATE TABLE sacoche_livret_element_item (
  livret_element_item_id  SMALLINT     UNSIGNED                NOT NULL AUTO_INCREMENT,
  livret_element_theme_id SMALLINT     UNSIGNED                NOT NULL DEFAULT 0,
  livret_element_item_nom VARCHAR(300) COLLATE utf8_unicode_ci NOT NULL DEFAULT "",
  PRIMARY KEY (livret_element_item_id),
  KEY livret_element_theme_id (livret_element_theme_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE sacoche_livret_element_item DISABLE KEYS;

INSERT INTO sacoche_livret_element_item (livret_element_item_id, livret_element_theme_id, livret_element_item_nom) VALUES

-- CP - Éducation physique et sportive

(NULL, 1, "Activités de roule (vélo, roller, …)."),
(NULL, 1, "Activités nautiques."),
(NULL, 1, "Natation."),
(NULL, 1, "Parcours d’escalade."),
(NULL, 1, "Parcours d’orientation."),
(NULL, 1, "Réaliser un parcours en adaptant ses déplacements à un environnement inhabituel dans un espace inhabituel et sécurisé."),
(NULL, 1, "Respecter les règles de sécurité qui s’appliquent."),
(NULL, 1, "Se déplacer dans l’eau sur une quinzaine de mètres sans appui et après un temps d’immersion."),

(NULL, 2, "Connaitre le but du jeu."),
(NULL, 2, "Contrôler son engagement moteur et affectif."),
(NULL, 2, "Jeux collectifs avec ballon."),
(NULL, 2, "Jeux de combat."),
(NULL, 2, "Jeux de raquettes."),
(NULL, 2, "Jeux traditionnels."),
(NULL, 2, "Reconnaitre ses partenaires et ses adversaires."),
(NULL, 2, "S’engager dans un affrontement individuel ou collectif en respectant les règles du jeu."),

(NULL, 3, "Activités athlétiques."),
(NULL, 3, "Courir, sauter, lancer à des intensités et des durées variables : courir vite et courir longtemps / lancer loin et lancer précis / sauter haut et sauter loin."),
(NULL, 3, "Remplir quelques rôles spécifiques (chronométreur, starter par exemple)."),

(NULL, 4, "Activités gymniques."),
(NULL, 4, "Arts du cirque."),
(NULL, 4, "Danse."),
(NULL, 4, "Inventer et présenter une séquence simple d’actions."),
(NULL, 4, "Mémoriser et reproduire avec son corps une séquence simple d’actions."),

-- CP - Enseignement moral et civique

(NULL, 11, "Acquérir une estime de soi."),
(NULL, 11, "Comprendre ses émotions et ses sentiments : leur origine et leurs manifestations."),
(NULL, 11, "Consolider sa confiance en soi."),
(NULL, 11, "Trouver les réponses appropriées aux besoins exprimés."),

(NULL, 12, "Identifier le drapeau français."),
(NULL, 12, "Reconnaitre La Marseillaise."),

(NULL, 13, "Développer son autonomie."),
(NULL, 13, "Identifier les risques et les dangers de son environnement immédiat et adopter un comportement adapté."),
(NULL, 13, "Prendre des initiatives personnelles et faire des choix sans craindre de se tromper."),
(NULL, 13, "Respecter les différents adultes de l’école en identifiant leur rôle."),
(NULL, 13, "Respecter les équipements de la collectivité, condition du partage de biens communs."),
(NULL, 13, "S’approprier les règles de l’école (droits et devoirs), pour soi-même (son propre bien-être et sa propre sécurité)."),
(NULL, 13, "Savoir que les enfants ont des droits (Convention internationale des droits de l’enfant, 1989)."),

(NULL, 14, "Avoir conscience de son intégrité."),
(NULL, 14, "Connaître et appliquer les règles élémentaires d’hygiène personnelle."),
(NULL, 14, "Connaître et respecter les règles élémentaires de l’intimité personnelle."),

-- CP - Enseignements artistiques

(NULL, 21, "Expérimenter, produire, créer des productions plastiques de natures diverses."),
(NULL, 21, "Mettre en œuvre un projet artistique individuel ou collectif."),
(NULL, 21, "S’exprimer, analyser sa pratique, celle de ses pairs ; établir une relation avec celle des artistes, s’ouvrir à l’altérité."),
(NULL, 21, "Se repérer dans les domaines liés aux arts plastiques, être sensible aux questions de l’art."),

(NULL, 22, "Chanter une mélodie simple, une comptine ou un chant avec une intonation juste."),
(NULL, 22, "Échanger, partager ses émotions, exprimer ses préférences."),
(NULL, 22, "Écouter, comparer des éléments sonores, des musiques."),
(NULL, 22, "Explorer, imaginer des représentations diverses de musiques."),

-- CP - Français

(NULL, 31, "Apprendre à écrire en écriture cursive."),
(NULL, 31, "Copier et acquérir des stratégies de copie."),
(NULL, 31, "Encoder puis écrire sous dictée."),
(NULL, 31, "Produire des écrits."),

(NULL, 32, "Découvrir, comprendre et mettre en œuvre l’orthographe grammaticale."),
(NULL, 32, "Se repérer dans la phrase simple."),

(NULL, 33, "Comprendre un texte."),
(NULL, 33, "Devenir lecteur."),
(NULL, 33, "Identifier les mots de manière de plus en plus aisée."),
(NULL, 33, "Lire à voix haute."),

(NULL, 34, "Dire pour être compris."),
(NULL, 34, "Écouter pour comprendre."),
(NULL, 34, "Participer à des échanges."),

(NULL, 35, "Enrichir son vocabulaire dans tous les enseignements."),
(NULL, 35, "Établir des relations entre les mots."),
(NULL, 35, "Mémoriser l’orthographe lexicale."),
(NULL, 35, "Réemployer le vocabulaire étudié."),

-- CP - Langues vivantes

(NULL, 41, "Niveau A1 - Comprendre des mots familiers et des expressions très courantes au sujet de soi, de sa famille et de l’environnement concret et immédiat, si les gens parlent lentement et distinctement."),

(NULL, 42, "Niveau A1 - Identifier quelques grands repères culturels de l’environnement quotidien des élèves du même âge dans les pays ou régions étudiés."),

(NULL, 43, "Niveau A1 - La prononciation d’un répertoire très limité d’expressions et de mots mémorisés est compréhensible avec quelque effort pour un locuteur natif."),
(NULL, 43, "Niveau A1 - Maîtriser quelques structures syntaxiques et formes grammaticales simples appartenant à un répertoire mémorisé."),
(NULL, 43, "Niveau A1 - Poser des questions simples sur des sujets familiers ou sur ce dont on a immédiatement besoin, ainsi que répondre à de telles questions."),

(NULL, 44, "Niveau A1 - La prononciation d’un répertoire très limité d’expressions et de mots mémorisés est compréhensible avec quelque effort pour un locuteur natif."),
(NULL, 44, "Niveau A1 - Maîtriser quelques structures syntaxiques et formes grammaticales simples appartenant à un répertoire mémorisé."),
(NULL, 44, "Niveau A1 - Utiliser des expressions et des phrases simples pour se décrire, décrire le lieu d’habitation et les gens de l’entourage."),

-- CP - Mathématiques

(NULL, 51, "La géométrie plane."),
(NULL, 51, "Le repérage dans l’espace."),
(NULL, 51, "Les solides."),

(NULL, 52, "La monnaie."),
(NULL, 52, "Le repérage dans le temps."),
(NULL, 52, "Les longueurs et les masses."),

(NULL, 53, "La résolution de problèmes."),
(NULL, 53, "Le calcul mental."),
(NULL, 53, "Les nombres entiers."),
(NULL, 53, "Les quatre opérations."),

-- CP - Questionner le monde

(NULL, 61, "Comparer quelques modes de vie des hommes et des femmes, et quelques représentations du monde."),
(NULL, 61, "Comprendre qu’un espace est organisé."),
(NULL, 61, "Identifier des paysages."),
(NULL, 61, "Se repérer dans l’espace et le représenter."),
(NULL, 61, "Situer un lieu sur une carte, sur un globe ou sur un écran informatique."),
(NULL, 61, "Repérer et situer quelques évènements dans un temps long."),
(NULL, 61, "Se repérer dans le temps et mesurer des durées."),

(NULL, 62, "Connaitre des caractéristiques du monde vivant, ses interactions, sa diversité."),
(NULL, 62, "Reconnaitre des comportements favorables à sa santé."),
(NULL, 62, "Commencer à s’approprier un environnement numérique."),
(NULL, 62, "Comprendre la fonction et le fonctionnement d’objets fabriqués."),
(NULL, 62, "Réaliser quelques objets et circuits électriques simples, en respectant des règles élémentaires de sécurité."),
(NULL, 62, "Identifier les trois états de la matière et observer des changements d’états."),
(NULL, 62, "Identifier un changement d’état de l’eau dans un phénomène de la vie quotidienne."),

-- CE1 - Éducation physique et sportive

(NULL, 71, "Activités de roule (vélo, roller, …)."),
(NULL, 71, "Activités nautiques."),
(NULL, 71, "Natation."),
(NULL, 71, "Parcours d’escalade."),
(NULL, 71, "Parcours d’orientation."),
(NULL, 71, "Réaliser un parcours en adaptant ses déplacements à un environnement inhabituel dans un espace inhabituel et sécurisé."),
(NULL, 71, "Respecter les règles de sécurité qui s’appliquent."),
(NULL, 71, "Se déplacer dans l’eau sur une quinzaine de mètres sans appui et après un temps d’immersion."),

(NULL, 72, "Connaitre le but du jeu."),
(NULL, 72, "Contrôler son engagement moteur et affectif."),
(NULL, 72, "Jeux collectifs avec ballon."),
(NULL, 72, "Jeux de combat."),
(NULL, 72, "Jeux de raquettes."),
(NULL, 72, "Jeux traditionnels."),
(NULL, 72, "Reconnaitre ses partenaires et ses adversaires."),
(NULL, 72, "S’engager dans un affrontement individuel ou collectif en respectant les règles du jeu."),

(NULL, 73, "Activités athlétiques."),
(NULL, 73, "Courir, sauter, lancer à des intensités et des durées variables : courir vite et courir longtemps / lancer loin et lancer précis / sauter haut et sauter loin."),
(NULL, 73, "Remplir quelques rôles spécifiques (chronométreur, starter par exemple)."),

(NULL, 74, "Activités gymniques."),
(NULL, 74, "Arts du cirque."),
(NULL, 74, "Danse."),
(NULL, 74, "Inventer et présenter une séquence simple d’actions."),
(NULL, 74, "Mémoriser et reproduire avec son corps une séquence simple d’actions."),

-- CE1 - Enseignement moral et civique

(NULL, 81, "Développer sa capacité d’empathie."),
(NULL, 81, "Faire comprendre que la solidarité et l’entraide, en lien avec la notion de fraternité, permettent un renforcement de la notion d’égalité entre les personnes."),
(NULL, 81, "Reconnaitre et prendre en compte les émotions et les sentiments d’autrui."),
(NULL, 81, "Reconnaitre la diversité comme richesse et ne pas faire des différences (sociales, physiques, culturelles, de genre) un motif de violence."),
(NULL, 81, "S’entraider et partager avec les autres."),

(NULL, 82, "Aborder le principe de la liberté de conscience."),
(NULL, 82, "Apprendre à chanter le 1er couplet et le refrain de La Marseillaise."),
(NULL, 82, "Comprendre la devise « Liberté, Égalité, Fraternité »."),
(NULL, 82, "Identifier les symboles républicains ;."),
(NULL, 82, "Savoir que le français est la langue de la République."),

(NULL, 83, "Connaître et appliquer les règles élémentaires de vie, de communication et d’échange en collectivité : l’idée de civilité."),
(NULL, 83, "Identifier les dangers au sein des situations dans lesquelles on se trouve."),
(NULL, 83, "Prendre des initiatives (faire des choix, les justifier)."),

-- CE1 - Enseignements artistiques

(NULL, 91, "Expérimenter, produire, créer des productions plastiques de natures diverses."),
(NULL, 91, "Mettre en œuvre un projet artistique individuel ou collectif."),
(NULL, 91, "S’exprimer, analyser sa pratique, celle de ses pairs ; établir une relation avec celle des artistes, s’ouvrir à l’altérité."),
(NULL, 91, "Se repérer dans les domaines liés aux arts plastiques, être sensible aux questions de l’art."),

(NULL, 92, "Chanter une mélodie simple, une comptine ou un chant avec une intonation juste."),
(NULL, 92, "Échanger, partager ses émotions, exprimer ses préférences."),
(NULL, 92, "Écouter, comparer des éléments sonores, des musiques."),
(NULL, 92, "Explorer, imaginer des représentations diverses de musiques."),

-- CE1 - Français

(NULL, 101, "Apprendre à écrire en écriture cursive."),
(NULL, 101, "Copier et acquérir des stratégies de copie."),
(NULL, 101, "Encoder puis écrire sous dictée."),
(NULL, 101, "Produire des écrits."),

(NULL, 102, "Découvrir, comprendre et mettre en œuvre l’orthographe grammaticale."),
(NULL, 102, "Se repérer dans la phrase simple."),

(NULL, 103, "Comprendre un texte."),
(NULL, 103, "Devenir lecteur."),
(NULL, 103, "Identifier les mots de manière de plus en plus aisée."),
(NULL, 103, "Lire à voix haute."),

(NULL, 104, "Dire pour être compris."),
(NULL, 104, "Écouter pour comprendre."),
(NULL, 104, "Participer à des échanges."),

(NULL, 105, "Enrichir son vocabulaire dans toutes les disciplines."),
(NULL, 105, "Établir des relations entre les mots."),
(NULL, 105, "Mémoriser l’orthographe des mots."),
(NULL, 105, "Réemployer le vocabulaire étudié."),

-- CE1 - Langues vivantes

(NULL, 111, "Niveau A1 - Comprendre des mots familiers et des expressions très courantes au sujet de soi, de sa famille et de l’environnement concret et immédiat, si les gens parlent lentement et distinctement."),

(NULL, 112, "Niveau A1 - Identifier quelques grands repères culturels de l’environnement quotidien des élèves du même âge dans les pays ou régions étudiés."),

(NULL, 113, "Niveau A1 - La prononciation d’un répertoire très limité d’expressions et de mots mémorisés est compréhensible avec quelque effort pour un locuteur natif."),
(NULL, 113, "Niveau A1 - Maîtriser quelques structures syntaxiques et formes grammaticales simples appartenant à un répertoire mémorisé."),
(NULL, 113, "Niveau A1 - Poser des questions simples sur des sujets familiers ou sur ce dont on a immédiatement besoin, ainsi que répondre à de telles questions."),

(NULL, 114, "Niveau A1 - La prononciation d’un répertoire très limité d’expressions et de mots mémorisés est compréhensible avec quelque effort pour un locuteur natif."),
(NULL, 114, "Niveau A1 - Maîtriser quelques structures syntaxiques et formes grammaticales simples appartenant à un répertoire mémorisé."),
(NULL, 114, "Niveau A1 - Utiliser des expressions et des phrases simples pour se décrire, décrire le lieu d’habitation et les gens de l’entourage."),

-- CE1 - Mathématiques

(NULL, 121, "La géométrie plane."),
(NULL, 121, "Le repérage dans l’espace."),
(NULL, 121, "Les solides."),

(NULL, 122, "La monnaie."),
(NULL, 122, "Le repérage dans le temps et les durées."),
(NULL, 122, "Les longueurs et les masses."),

(NULL, 123, "La résolution de problèmes."),
(NULL, 123, "Le calcul mental."),
(NULL, 123, "Les fractions."),
(NULL, 123, "Les nombres entiers."),
(NULL, 123, "Les quatre opérations."),

-- CE1 - Questionner le monde

(NULL, 131, "Comparer quelques modes de vie des hommes et des femmes, et quelques représentations du monde."),
(NULL, 131, "Comprendre qu’un espace est organisé."),
(NULL, 131, "Identifier des paysages."),
(NULL, 131, "Se repérer dans l’espace et le représenter."),
(NULL, 131, "Situer un lieu sur une carte, sur un globe ou sur un écran informatique."),
(NULL, 131, "Repérer et situer quelques évènements dans un temps long."),
(NULL, 131, "Se repérer dans le temps et mesurer des durées."),

(NULL, 132, "Connaitre des caractéristiques du monde vivant, ses interactions, sa diversité."),
(NULL, 132, "Reconnaitre des comportements favorables à sa santé."),
(NULL, 132, "Commencer à s’approprier un environnement numérique."),
(NULL, 132, "Comprendre la fonction et le fonctionnement d’objets fabriqués."),
(NULL, 132, "Réaliser quelques objets et circuits électriques simples, en respectant des règles élémentaires de sécurité."),
(NULL, 132, "Identifier les trois états de la matière et observer des changements d’états."),
(NULL, 132, "Identifier un changement d’état de l’eau dans un phénomène de la vie quotidienne."),

-- CE2 - Éducation physique et sportive

(NULL, 141, "Activités de roule (vélo, roller, …)."),
(NULL, 141, "Activités nautiques."),
(NULL, 141, "Natation."),
(NULL, 141, "Parcours d’escalade."),
(NULL, 141, "Parcours d’orientation."),
(NULL, 141, "Réaliser un parcours en adaptant ses déplacements à un environnement inhabituel dans un espace inhabituel et sécurisé."),
(NULL, 141, "Respecter les règles de sécurité qui s’appliquent."),
(NULL, 141, "Se déplacer dans l’eau sur une quinzaine de mètres sans appui et après un temps d’immersion."),

(NULL, 142, "Connaitre le but du jeu."),
(NULL, 142, "Contrôler son engagement moteur et affectif."),
(NULL, 142, "Jeux collectifs avec ballon."),
(NULL, 142, "Jeux de combat."),
(NULL, 142, "Jeux de raquettes."),
(NULL, 142, "Jeux traditionnels."),
(NULL, 142, "Reconnaitre ses partenaires et ses adversaires."),
(NULL, 142, "S’engager dans un affrontement individuel ou collectif en respectant les règles du jeu."),

(NULL, 143, "Activités athlétiques."),
(NULL, 143, "Courir, sauter, lancer à des intensités et des durées variables : courir vite et courir longtemps / lancer loin et lancer précis / sauter haut et sauter loin."),
(NULL, 143, "Remplir quelques rôles spécifiques (chronométreur, starter par exemple)."),

(NULL, 144, "Activités gymniques."),
(NULL, 144, "Arts du cirque."),
(NULL, 144, "Danse."),
(NULL, 144, "Inventer et présenter une séquence simple d’actions."),
(NULL, 144, "Mémoriser et reproduire avec son corps une séquence simple d’actions."),

-- CE2 - Enseignement moral et civique

(NULL, 151, "Aborder des enjeux d’intérêt collectif : l’éducation pour tous, l’environnement, la sécurité, l’information."),
(NULL, 151, "Savoir qu’il existe des institutions et des associations au service du bien commun."),
(NULL, 151, "Sensibiliser à la notion de bien commun et amener les élèves à prendre conscience que les actions individuelles doivent tenir compte de l’intérêt collectif."),

(NULL, 152, "Approfondir la compréhension de la devise « Liberté, Égalité, Fraternité »."),
(NULL, 152, "Savoir qu’en France le chef de l’État est le président de la République et qu’il est élu."),
(NULL, 152, "Savoir que le maire est un élu local, et le représentant de l’État dans la commune ; connaître son rôle à la tête de la collectivité (état civil, école, environnement)."),

-- CE2 - Enseignements artistiques

(NULL, 161, "Expérimenter, produire, créer des productions plastiques de natures diverses."),
(NULL, 161, "Mettre en œuvre un projet artistique individuel ou collectif."),
(NULL, 161, "S’exprimer, analyser sa pratique, celle de ses pairs ; établir une relation avec celle des artistes, s’ouvrir à l’altérité."),
(NULL, 161, "Se repérer dans les domaines liés aux arts plastiques, être sensible aux questions de l’art."),

(NULL, 162, "Chanter une mélodie simple, une comptine ou un chant avec une intonation juste."),
(NULL, 162, "Échanger, partager ses émotions, exprimer ses préférences."),
(NULL, 162, "Écouter, comparer des éléments sonores, des musiques."),
(NULL, 162, "Explorer, imaginer des représentations diverses de musiques."),

-- CE2 - Français

(NULL, 171, "Apprendre à écrire en écriture cursive."),
(NULL, 171, "Copier et acquérir des stratégies de copie."),
(NULL, 171, "Encoder puis écrire sous dictée."),
(NULL, 171, "Produire des écrits."),

(NULL, 172, "Découvrir, comprendre et mettre en œuvre l’orthographe grammaticale."),
(NULL, 172, "Se repérer dans la phrase simple."),

(NULL, 173, "Comprendre un texte."),
(NULL, 173, "Devenir lecteur."),
(NULL, 173, "Identifier les mots de manière de plus en plus aisée."),
(NULL, 173, "Lire à voix haute."),

(NULL, 174, "Dire pour être compris."),
(NULL, 174, "Écouter pour comprendre."),
(NULL, 174, "Participer à des échanges."),

(NULL, 175, "Enrichir son vocabulaire dans toutes les disciplines."),
(NULL, 175, "Établir des relations entre les mots."),
(NULL, 175, "Mémoriser l’orthographe des mots."),
(NULL, 175, "Réemployer le vocabulaire étudié."),

-- CE2 - Langues vivantes

(NULL, 181, "Niveau A1 - Comprendre des mots familiers et des expressions très courantes au sujet de soi, de sa famille et de l’environnement concret et immédiat, si les gens parlent lentement et distinctement."),

(NULL, 182, "Niveau A1 - Identifier quelques grands repères culturels de l’environnement quotidien des élèves du même âge dans les pays ou régions étudiés."),

(NULL, 183, "Niveau A1 - La prononciation d’un répertoire très limité d’expressions et de mots mémorisés est compréhensible avec quelque effort pour un locuteur natif."),
(NULL, 183, "Niveau A1 - Maîtriser quelques structures syntaxiques et formes grammaticales simples appartenant à un répertoire mémorisé."),
(NULL, 183, "Niveau A1 - Poser des questions simples sur des sujets familiers ou sur ce dont on a immédiatement besoin, ainsi que répondre à de telles questions."),

(NULL, 184, "Niveau A1 - La prononciation d’un répertoire très limité d’expressions et de mots mémorisés est compréhensible avec quelque effort pour un locuteur natif."),
(NULL, 184, "Niveau A1 - Maîtriser quelques structures syntaxiques et formes grammaticales simples appartenant à un répertoire mémorisé."),
(NULL, 184, "Niveau A1 - Utiliser des expressions et des phrases simples pour se décrire, décrire le lieu d’habitation et les gens de l’entourage."),

-- CE2 - Mathématiques

(NULL, 191, "La géométrie plane."),
(NULL, 191, "Les solides."),

(NULL, 192, "La monnaie."),
(NULL, 192, "Le repérage dans le temps et les durées."),
(NULL, 192, "Les longueurs, les masses et les contenances."),

(NULL, 193, "La résolution de problèmes."),
(NULL, 193, "Le calcul mental."),
(NULL, 193, "Les fractions."),
(NULL, 193, "Les nombres entiers."),
(NULL, 193, "Les quatre opérations."),

-- CE2 - Questionner le monde

(NULL, 201, "Comparer quelques modes de vie des hommes et des femmes, et quelques représentations du monde."),
(NULL, 201, "Comprendre qu’un espace est organisé."),
(NULL, 201, "Identifier des paysages."),
(NULL, 201, "Se repérer dans l’espace et le représenter."),
(NULL, 201, "Situer un lieu sur une carte, sur un globe ou sur un écran informatique."),
(NULL, 201, "Repérer et situer quelques évènements dans un temps long."),
(NULL, 201, "Se repérer dans le temps et mesurer des durées."),

(NULL, 202, "Connaitre des caractéristiques du monde vivant, ses interactions, sa diversité."),
(NULL, 202, "Reconnaitre des comportements favorables à sa santé."),
(NULL, 202, "Commencer à s’approprier un environnement numérique."),
(NULL, 202, "Comprendre la fonction et le fonctionnement d’objets fabriqués."),
(NULL, 202, "Réaliser quelques objets et circuits électriques simples, en respectant des règles élémentaires de sécurité."),
(NULL, 202, "Identifier les trois états de la matière et observer des changements d’états."),
(NULL, 202, "Identifier un changement d’état de l’eau dans un phénomène de la vie quotidienne."),

-- CM1 - Éducation physique et sportive

(NULL, 211, "Activités de roule (vélo, roller…)."),
(NULL, 211, "Activités nautiques."),
(NULL, 211, "Connaitre et respecter les règles de sécurité qui s’appliquent à chaque environnement."),
(NULL, 211, "Identifier la personne responsable à alerter ou la procédure en cas de problème."),
(NULL, 211, "Parcours d’escalade."),
(NULL, 211, "Parcours d’orientation."),
(NULL, 211, "Réaliser, seul ou à plusieurs, un parcours dans plusieurs environnements inhabituels, en milieu naturel aménagé ou artificiel."),
(NULL, 211, "Savoir nager."),
(NULL, 211, "Valider l’attestation scolaire du savoir nager (ASSN)."),

(NULL, 212, "Accepter le résultat de la rencontre."),
(NULL, 212, "Assurer différents rôles sociaux (joueur, arbitre, observateur)."),
(NULL, 212, "Jeux collectifs avec ballons."),
(NULL, 212, "Jeux de combat."),
(NULL, 212, "Jeux de raquettes."),
(NULL, 212, "Jeux traditionnels."),
(NULL, 212, "Respecter les partenaires, les adversaires et l’arbitre."),
(NULL, 212, "S’organiser tactiquement pour rechercher le gain du match (ou du combat)."),

(NULL, 213, "Activités athlétiques."),
(NULL, 213, "Assumer les rôles de chronométreur et d’observateur."),
(NULL, 213, "Combiner une course, un saut, un lancer pour faire la meilleure performance cumulée."),
(NULL, 213, "Mesurer et quantifier les performances, les enregistrer, les comparer, les classer, les traduire en représentations graphiques."),
(NULL, 213, "Natation."),

(NULL, 214, "Activités gymniques."),
(NULL, 214, "Arts du cirque."),
(NULL, 214, "Danse."),
(NULL, 214, "Réaliser en petits groupes une séquence acrobatique ou à visée artistique."),
(NULL, 214, "Respecter les prestations des autres et accepter de se produire devant les autres."),
(NULL, 214, "Savoir filmer une prestation pour la revoir et la faire évoluer."),

-- CM1 - Enseignement moral et civique

(NULL, 221, "Aborder des exemples de comportement civique dans la classe, l’école, dans la vie quotidienne, en ligne, et en faveur de l’environnement."),
(NULL, 221, "Apprendre la signification du terme « démocratie » et le fonctionnement du suffrage direct."),
(NULL, 221, "Connaître et appliquer les règles de civilité en société ; identifier les incivilités et comprendre pourquoi elles nuisent à la vie en commun."),
(NULL, 221, "Définir le civisme comme l’action d’un individu en fonction du bien public et dans le respect des règles."),

(NULL, 222, "Comprendre ce qu’implique et permet l’empathie."),
(NULL, 222, "Comprendre ce qu’implique le principe de dignité de la personne humaine."),
(NULL, 222, "Comprendre la notion d’égalité en droit."),
(NULL, 222, "Comprendre la notion de fraternité, valeur et principe de la République."),

-- CM1 - Enseignements artistiques

(NULL, 231, "Expérimenter, produire, créer des productions plastiques de natures diverses."),
(NULL, 231, "Mettre en œuvre un projet artistique individuel ou collectif."),
(NULL, 231, "S’exprimer, analyser sa pratique, celle de ses pairs ; établir une relation avec celle des artistes, s’ouvrir à l’altérité."),
(NULL, 231, "Se repérer dans les domaines liés aux arts plastiques, connaître et comparer quelques œuvres d’art."),

(NULL, 232, "Chanter et interpréter une mélodie simple avec une intonation juste et avec expressivité."),
(NULL, 232, "Échanger, partager et argumenter ses choix et ses préférences."),
(NULL, 232, "Écouter, comparer et commenter des éléments sonores d’origines diverses."),
(NULL, 232, "Explorer, imaginer et créer des représentations diverses de musique."),

(NULL, 233, "Dégager d’une œuvre d’art, par l’observation ou l’écoute, ses principales caractéristiques techniques et formelles."),
(NULL, 233, "Donner un avis argumenté sur ce que représente ou exprime une œuvre d’art."),
(NULL, 233, "Relier des caractéristiques d’une œuvre d’art à des usages ainsi qu’au contexte historique et culturel de sa création."),
(NULL, 233, "Se repérer dans un musée, dans un lieu d’art, un site patrimonial."),

-- CM1 - Français

(NULL, 241, "Comprendre et interroger la morale."),
(NULL, 241, "Découvrir des héroïnes, des héros."),
(NULL, 241, "Imaginer et vivre d’autres vies."),
(NULL, 241, "Savourer le goût des mots, imaginer et créer en poésie."),
(NULL, 241, "Se confronter au merveilleux, à l’étrange."),
(NULL, 241, "Se découvrir, s’affirmer dans le rapport aux autres."),

(NULL, 242, "Écrire à la main de manière fluide et efficace."),
(NULL, 242, "Écrire pour réfléchir, apprendre et mémoriser."),
(NULL, 242, "Produire des écrits variés."),

(NULL, 243, "Acquérir l’orthographe grammaticale."),
(NULL, 243, "Identifier les constituants d’une phrase simple."),

(NULL, 244, "Lire à voix haute avec expressivité."),
(NULL, 244, "Lire avec fluidité."),
(NULL, 244, "Lire et comprendre des textes, des documents et des images pour apprendre dans toutes les disciplines."),
(NULL, 244, "Lire et comprendre seul des textes, des documents et des images."),
(NULL, 244, "Lire une œuvre et se l’approprier."),

(NULL, 245, "Dire pour être compris dans toutes les disciplines."),
(NULL, 245, "Écouter pour comprendre."),
(NULL, 245, "Participer à des échanges verbaux."),

(NULL, 246, "Enrichir son vocabulaire dans toutes les disciplines."),
(NULL, 246, "Établir des relations entre les mots."),
(NULL, 246, "Mémoriser l’orthographe des mots."),
(NULL, 246, "Réemployer le vocabulaire étudié."),

-- CM1 - Histoire et géographie

(NULL, 251, "Comprendre le sens général d’un document."),
(NULL, 251, "Extraire des informations pertinentes."),
(NULL, 251, "Identifier le document et savoir pourquoi il doit être identifié."),
(NULL, 251, "Savoir que le document exprime un point de vue, identifier et questionner le sens implicite d’un document."),

(NULL, 252, "Organiser son travail dans le cadre d’un groupe."),
(NULL, 252, "Travailler en commun."),
(NULL, 252, "Utiliser les outils numériques dans le travail collectif."),

(NULL, 253, "Consommer en France."),
(NULL, 253, "Découvrir le(s) lieu(x) où j’habite."),
(NULL, 253, "Se loger, travailler, se cultiver, avoir des loisirs en France."),

(NULL, 254, "Et avant la France ?."),
(NULL, 254, "Le temps de la Révolution et de l’Empire."),
(NULL, 254, "Le temps des rois."),

(NULL, 255, "Écrire pour structurer sa pensée, argumenter et écrire pour communiquer."),
(NULL, 255, "Réaliser des productions."),
(NULL, 255, "Reconnaître un récit historique."),
(NULL, 255, "S’approprier et utiliser un lexique historique et géographique."),
(NULL, 255, "S’exprimer à l’oral."),
(NULL, 255, "Utiliser des cartes."),

(NULL, 256, "Formuler des hypothèses."),
(NULL, 256, "Justifier."),
(NULL, 256, "Poser et se poser des questions."),
(NULL, 256, "Vérifier."),

(NULL, 257, "Connaitre et utiliser différents systèmes d’information."),
(NULL, 257, "Identifier la ressource numérique utilisée."),
(NULL, 257, "Trouver, sélectionner et exploiter des informations dans une ressource numérique."),

(NULL, 258, "Appréhender la notion d’échelle géographique."),
(NULL, 258, "Mémoriser et mobiliser ses repères géographiques."),
(NULL, 258, "Nommer et localiser les grands repères géographiques."),
(NULL, 258, "Nommer, localiser un lieu dans un espace géographique."),

(NULL, 259, "Mémoriser et mobiliser ses repères historiques."),
(NULL, 259, "Ordonner des faits et les situer."),
(NULL, 259, "Situer des grandes périodes historiques."),
(NULL, 259, "Utiliser des documents."),

-- CM1 - Langues vivantes

(NULL, 261, "Niveau A1 - Identifier quelques grands repères culturels de l’environnement quotidien des élèves du même âge dans les pays ou régions étudiés."),

(NULL, 262, "Niveau A1 - Comprendre des mots familiers et des expressions très courantes sur soi-même, sa famille et son environnement."),

(NULL, 263, "Niveau A1 - Copier un modèle écrit, écrire un court message et renseigner un questionnaire simple."),

(NULL, 264, "Niveau A1 - Comprendre dans un message des mots familiers et des phrases très simples."),

(NULL, 265, "Niveau A1 - La prononciation d’un répertoire très limité d’expressions et de mots mémorisés est compréhensible avec quelque effort pour un locuteur natif."),
(NULL, 265, "Niveau A1 - Maîtriser quelques structures syntaxiques et formes grammaticales simples appartenant à un répertoire mémorisé."),
(NULL, 265, "Niveau A1 - Utiliser des expressions et des phrases simples pour parler de soi et de son environnement immédiat."),

(NULL, 266, "Niveau A1 - Communiquer, de façon simple, avec l’aide de l’interlocuteur."),
(NULL, 266, "Niveau A1 - La prononciation d’un répertoire très limité d’expressions et de mots mémorisés est compréhensible avec quelque effort pour un locuteur natif."),
(NULL, 266, "Niveau A1 - Maîtriser quelques structures syntaxiques et formes grammaticales simples appartenant à un répertoire mémorisé."),

-- CM1 - Mathématiques

(NULL, 271, "La géométrie plane."),
(NULL, 271, "Le repérage dans l’espace."),
(NULL, 271, "Les solides."),

(NULL, 272, "Le repérage dans le temps et les durées."),
(NULL, 272, "Les aires."),
(NULL, 272, "Les angles."),
(NULL, 272, "Les contenances."),
(NULL, 272, "Les longueurs."),
(NULL, 272, "Les masses."),

(NULL, 273, "Algèbre."),
(NULL, 273, "La résolution de problèmes."),
(NULL, 273, "Le calcul mental."),
(NULL, 273, "Les fractions."),
(NULL, 273, "Les nombres décimaux."),
(NULL, 273, "Les nombres entiers."),
(NULL, 273, "Les quatre opérations."),

(NULL, 274, "Les probabilités."),
(NULL, 274, "Organisation et gestion de données."),

-- CM1 - Sciences et technologie

(NULL, 281, "Adopter un comportement éthique et responsable."),
(NULL, 281, "Concevoir, créer, réaliser."),
(NULL, 281, "Faire preuve d’esprit critique."),
(NULL, 281, "Mobiliser des outils numériques."),
(NULL, 281, "Pratiquer des démarches scientifiques et technologiques."),
(NULL, 281, "Pratiquer des langages."),
(NULL, 281, "Se situer dans l’espace et dans le temps."),

(NULL, 282, "Conséquences des actions humaines sur l’environnement."),
(NULL, 282, "Écosystème."),
(NULL, 282, "Place des êtres vivants dans les chaînes alimentaires."),
(NULL, 282, "La Terre, une planète active qui abrite la vie."),

(NULL, 283, "Besoins alimentaires et nutrition humaine."),
(NULL, 283, "Production et conservation des aliments."),
(NULL, 283, "Cycle de vie."),
(NULL, 283, "Reproduction et sexualité humaine."),
(NULL, 283, "Biodiversité actuelle et passée."),
(NULL, 283, "Classification du vivant."),
(NULL, 283, "Organisation des êtres vivants."),

(NULL, 284, "Cycle de vie de l’objet technique."),
(NULL, 284, "Notion de contrainte (imperméabilité, poids, autonomie, etc.)."),
(NULL, 284, "Problème technique."),
(NULL, 284, "Processus de réalisation de maquettes."),
(NULL, 284, "Besoins et fonctions techniques."),
(NULL, 284, "Représentation des objets techniques."),
(NULL, 284, "Solutions technologiques."),
(NULL, 284, "Besoin exprimé par l’individu, la société."),
(NULL, 284, "Evolution technologique (innovation, invention, principe technique, approche environnementale)."),
(NULL, 284, "Algorithmes et programmation."),
(NULL, 284, "Les objets programmables."),

(NULL, 285, "Mouvements."),
(NULL, 285, "Masse et volume."),
(NULL, 285, "Mélanges."),
(NULL, 285, "Propriétés de la matière."),
(NULL, 285, "Conversions d’énergie."),
(NULL, 285, "Électricité."),
(NULL, 285, "Lumière."),

-- CM2 - Éducation physique et sportive

(NULL, 291, "Activités de roule (vélo, roller…)."),
(NULL, 291, "Activités nautiques."),
(NULL, 291, "Connaitre et respecter les règles de sécurité qui s’appliquent à chaque environnement."),
(NULL, 291, "Identifier la personne responsable à alerter ou la procédure en cas de problème."),
(NULL, 291, "Parcours d’escalade."),
(NULL, 291, "Parcours d’orientation."),
(NULL, 291, "Réaliser, seul ou à plusieurs, un parcours dans plusieurs environnements inhabituels, en milieu naturel aménagé ou artificiel."),
(NULL, 291, "Savoir nager."),
(NULL, 291, "Valider l’attestation scolaire du savoir nager (ASSN)."),

(NULL, 292, "Accepter le résultat de la rencontre."),
(NULL, 292, "Assurer différents rôles sociaux (joueur, arbitre, observateur)."),
(NULL, 292, "Jeux collectifs avec ballons."),
(NULL, 292, "Jeux de combat."),
(NULL, 292, "Jeux de raquettes."),
(NULL, 292, "Jeux traditionnels."),
(NULL, 292, "Respecter les partenaires, les adversaires et l’arbitre."),
(NULL, 292, "S’organiser tactiquement pour rechercher le gain du match (ou du combat)."),

(NULL, 293, "Activités athlétiques."),
(NULL, 293, "Assumer les rôles de chronométreur et d’observateur."),
(NULL, 293, "Combiner une course, un saut, un lancer pour faire la meilleure performance cumulée."),
(NULL, 293, "Mesurer et quantifier les performances, les enregistrer, les comparer, les classer, les traduire en représentations graphiques."),
(NULL, 293, "Natation."),

(NULL, 294, "Activités gymniques."),
(NULL, 294, "Arts du cirque."),
(NULL, 294, "Danse."),
(NULL, 294, "Réaliser en petits groupes une séquence acrobatique ou à visée artistique."),
(NULL, 294, "Respecter les prestations des autres et accepter de se produire devant les autres."),
(NULL, 294, "Savoir filmer une prestation pour la revoir et la faire évoluer."),

-- CM2 - Enseignement moral et civique

(NULL, 301, "Le respect des croyances est assuré, mais, comme ailleurs, leur expression est limitée par la loi. Celle-ci protège les élèves de toute influence religieuse et préserve leur liberté de conscience."),
(NULL, 301, "Nul ne peut être discriminé pour sa croyance ou ses convictions, mais nul n’a non plus le droit d’imposer ses croyances ou ses convictions aux autres."),

(NULL, 302, "Comprendre que le terme de devoir peut aussi désigner une réalité plus morale, qui doit guider le citoyen dans son comportement dans l’espace public."),
(NULL, 302, "Connaître et comprendre les symboles républicains mentionnés par la Constitution : drapeau, hymne, devise, et d’autres coutumiers comme Marianne ; connaître la fête nationale du 14 juillet (héritière de la Fête de la Fédération de 1790) ; comprendre la nécessité de respecter ces symboles."),
(NULL, 302, "Connaître le rôle politique des citoyennes et des citoyens : ils ont vocation à participer à la vie politique du pays et à l’évolution des institutions (découverte d’élaboration de la loi)."),
(NULL, 302, "Connaître les conditions d’acquisition de la nationalité française : montrer le lien étroit entre citoyenneté et nationalité. Un citoyen bénéficie de droits civils, puis politiques à sa majorité, et tout individu bénéficie de droits civils."),
(NULL, 302, "Connaître les devoirs du citoyen et de toute personne résidant sur le territoire national :  respecter les lois, contribuer à financer les dépenses publiques. Chaque citoyen doit respecter les droits des autres qui sont identiques aux siens (Déclaration des droits de l’homme et du citoyen)."),
(NULL, 302, "Savoir que la République française est membre de l’Union européenne (UE)."),

(NULL, 303, "Approfondir avec les droits dits « de troisième génération », qui résultent du droit de chacun de « vivre dans un environnement équilibré et respectueux de la santé » (art. 1er de la Charte de l’environnement)."),
(NULL, 303, "Faire connaître les droits et libertés fondamentaux institués par la Déclaration des droits de l’homme et du citoyen (1789), la Déclaration universelle des droits de l’homme (1948) et la Charte des droits fondamentaux de l’Union européenne (2000)."),
(NULL, 303, "Mettre en avant certains droits politiques, économiques et sociaux qui en découlent : suffrage universel, droit à l’emploi, à la protection de la santé, à la gratuité de l’enseignement public, accès à la culture, droits environnementaux (Charte de l’environnement)."),
(NULL, 303, "Montrer que les droits fondamentaux s’exercent dans le cadre de la loi (exemple de la liberté d’expression)."),

(NULL, 304, "Faire reconnaitre les atteintes aux personnes : le racisme, l’antisémitisme, le sexisme, la xénophobie, l’homophobie, le harcèlement ; savoir que l’expression des discriminations est sanctionnée par la loi."),
(NULL, 304, "Montrer que la lutte contre les discriminations suppose la déconstruction des préjugés et des stéréotypes."),

-- CM2 - Enseignements artistiques

(NULL, 311, "Expérimenter, produire, créer des productions plastiques de natures diverses."),
(NULL, 311, "Mettre en œuvre un projet artistique individuel ou collectif."),
(NULL, 311, "S’exprimer, analyser sa pratique, celle de ses pairs ; établir une relation avec celle des artistes, s’ouvrir à l’altérité."),
(NULL, 311, "Se repérer dans les domaines liés aux arts plastiques, connaître et comparer quelques œuvres d’art."),

(NULL, 312, "Chanter et interpréter une mélodie simple avec une intonation juste et avec expressivité."),
(NULL, 312, "Échanger, partager et argumenter ses choix et ses préférences."),
(NULL, 312, "Écouter, comparer et commenter des éléments sonores d’origines diverses."),
(NULL, 312, "Explorer, imaginer et créer des représentations diverses de musique."),

(NULL, 313, "Dégager d’une œuvre d’art, par l’observation ou l’écoute, ses principales caractéristiques techniques et formelles."),
(NULL, 313, "Donner un avis argumenté sur ce que représente ou exprime une œuvre d’art."),
(NULL, 313, "Relier des caractéristiques d’une œuvre d’art à des usages ainsi qu’au contexte historique et culturel de sa création."),
(NULL, 313, "Se repérer dans un musée, dans un lieu d’art, un site patrimonial."),

-- CM2 - Français

(NULL, 321, "Écrire à la main de manière fluide et efficace."),
(NULL, 321, "Maitriser les bases de l’écriture au clavier."),
(NULL, 321, "Prendre en compte les normes de l’écrit pour formuler, transcrire et réviser."),
(NULL, 321, "Recourir à l’écriture pour réfléchir et pour apprendre."),
(NULL, 321, "Rédiger des écrits variés."),
(NULL, 321, "Réécrire à partir de nouvelles consignes ou faire évoluer son texte."),

(NULL, 322, "Acquérir l’ortographe grammaticale."),
(NULL, 322, "Identifier les constituants d’une phrase simple."),
(NULL, 322, "Maitriser les relations entre l’oral et l’écrit."),
(NULL, 322, "Se repérer dans la phrase complexe."),

(NULL, 323, "Comprendre des textes, des documents et des images et les interpréter."),
(NULL, 323, "Comprendre un texte littéraire et se l’approprier."),
(NULL, 323, "Contrôler sa compréhension, être un lecteur autonome."),
(NULL, 323, "Lire avec fluidité."),

(NULL, 324, "Adopter une attitude critique par rapport à son propos."),
(NULL, 324, "Écouter pour comprendre un message oral, un propos, un discours, un texte lu."),
(NULL, 324, "Parler en prenant en compte son auditoire."),
(NULL, 324, "Participer à des échanges dans des situations diverses (séances d’apprentissage ordinaire, séances de régulation de la vie de classe, jeux de rôles improvisés ou préparés)."),

(NULL, 325, "Acquérir l’orthographe lexicale."),
(NULL, 325, "Enrichir le lexique."),

-- CM2 - Histoire et géographie

(NULL, 331, "Comprendre le sens général d’un document."),
(NULL, 331, "Extraire des informations pertinentes."),
(NULL, 331, "Identifier le document et savoir pourquoi il doit être identifié."),
(NULL, 331, "Savoir que le document exprime un point de vue, identifier et questionner le sens implicite d’un document."),

(NULL, 332, "Organiser son travail dans le cadre d’un groupe."),
(NULL, 332, "Travailler en commun."),
(NULL, 332, "Utiliser les outils numériques dans le travail collectif."),

(NULL, 333, "Communiquer d’un bout à l’autre du monde grâce à internet."),
(NULL, 333, "Mieux habiter."),
(NULL, 333, "Se déplacer."),

(NULL, 334, "L’âge industriel en France."),
(NULL, 334, "La France, des guerres mondiales à l’Union européenne."),
(NULL, 334, "Le temps de la République."),

(NULL, 335, "Écrire pour structurer sa pensée, argumenter et écrire pour communiquer."),
(NULL, 335, "Réaliser des productions."),
(NULL, 335, "Reconnaître un récit historique."),
(NULL, 335, "S’approprier et utiliser un lexique historique et géographique."),
(NULL, 335, "S’exprimer à l’oral."),
(NULL, 335, "Utiliser des cartes."),

(NULL, 336, "Formuler des hypothèses."),
(NULL, 336, "Justifier."),
(NULL, 336, "Poser et se poser des questions."),
(NULL, 336, "Vérifier."),

(NULL, 337, "Connaitre et utiliser différents systèmes d’information."),
(NULL, 337, "Identifier la ressource numérique utilisée."),
(NULL, 337, "Trouver, sélectionner et exploiter des informations dans une ressource numérique."),

(NULL, 338, "Appréhender la notion d’échelle géographique."),
(NULL, 338, "Mémoriser et mobiliser ses repères géographiques."),
(NULL, 338, "Nommer et localiser les grands repères géographiques."),
(NULL, 338, "Nommer, localiser un lieu dans un espace géographique."),

(NULL, 339, "Mémoriser et mobiliser ses repères historiques."),
(NULL, 339, "Ordonner des faits et les situer."),
(NULL, 339, "Situer des grandes périodes historiques."),
(NULL, 339, "Utiliser des documents."),

-- CM2 - Langues vivantes

(NULL, 341, "Niveau A1 - Identifier quelques grands repères culturels de l’environnement quotidien des élèves du même âge dans les pays ou régions étudiés."),

(NULL, 342, "Niveau A1 - Comprendre des mots familiers et des expressions très courantes sur soi-même, sa famille et son environnement."),

(NULL, 343, "Niveau A1 - Copier un modèle écrit, écrire un court message et renseigner un questionnaire simple."),

(NULL, 344, "Niveau A1 - Comprendre dans un message des mots familiers et des phrases très simples."),

(NULL, 345, "Niveau A1 - La prononciation d’un répertoire très limité d’expressions et de mots mémorisés est compréhensible avec quelque effort pour un locuteur natif."),
(NULL, 345, "Niveau A1 - Maîtriser quelques structures syntaxiques et formes grammaticales simples appartenant à un répertoire mémorisé."),
(NULL, 345, "Niveau A1 - Utiliser des expressions et des phrases simples pour parler de soi et de son environnement immédiat."),

(NULL, 346, "Niveau A1 - Communiquer, de façon simple, avec l’aide de l’interlocuteur."),
(NULL, 346, "Niveau A1 - La prononciation d’un répertoire très limité d’expressions et de mots mémorisés est compréhensible avec quelque effort pour un locuteur natif."),
(NULL, 346, "Niveau A1 - Maîtriser quelques structures syntaxiques et formes grammaticales simples appartenant à un répertoire mémorisé."),

-- CM2 - Mathématiques

(NULL, 351, "(Se) repérer et (se) déplacer en utilisant ou en élaborant des représentations."),
(NULL, 351, "Reconnaitre et utiliser quelques relations géométriques."),
(NULL, 351, "Reconnaitre, nommer, décrire, reproduire, représenter, construire quelques solides et figures géométriques."),

(NULL, 352, "Comparer, estimer, mesurer des grandeurs géométriques avec des nombres entiers et des nombres décimaux : longueur (périmètre), aire, volume, angle."),
(NULL, 352, "Résoudre des problèmes impliquant des grandeurs (géométriques, physiques, économiques) en utilisant des nombres entiers et des nombres décimaux."),
(NULL, 352, "Utiliser le lexique, les unités, les instruments de mesures spécifiques de ces grandeurs."),

(NULL, 353, "Calculer avec des nombres entiers et des nombres décimaux."),
(NULL, 353, "Résoudre des problèmes en utilisant des fractions, des nombres décimaux et le calcul."),
(NULL, 353, "Utiliser et représenter les grands nombres entiers, des fractions simples, les nombres décimaux."),

-- CM2 - Sciences et technologie

(NULL, 361, "Adopter un comportement éthique et responsable."),
(NULL, 361, "Concevoir, créer, réaliser."),
(NULL, 361, "Faire preuve d’esprit critique."),
(NULL, 361, "Mobiliser des outils numériques."),
(NULL, 361, "Pratiquer des démarches scientifiques et technologiques."),
(NULL, 361, "Pratiquer des langages."),
(NULL, 361, "Se situer dans l’espace et dans le temps."),

(NULL, 362, "Conséquences des actions humaines sur l’environnement."),
(NULL, 362, "Écosystème."),
(NULL, 362, "Place des êtres vivants dans les chaînes alimentaires."),
(NULL, 362, "La Terre, une planète active qui abrite la vie."),

(NULL, 363, "Besoins alimentaires et nutrition humaine."),
(NULL, 363, "Production et conservation des aliments."),
(NULL, 363, "Cycle de vie."),
(NULL, 363, "Reproduction et sexualité humaine."),
(NULL, 363, "Biodiversité actuelle et passée."),
(NULL, 363, "Classification du vivant."),
(NULL, 363, "Organisation des êtres vivants."),

(NULL, 364, "Cycle de vie de l’objet technique."),
(NULL, 364, "Notion de contrainte (imperméabilité, poids, autonomie, etc.)."),
(NULL, 364, "Problème technique."),
(NULL, 364, "Processus de réalisation de maquettes."),
(NULL, 364, "Besoins et fonctions techniques."),
(NULL, 364, "Représentation des objets techniques."),
(NULL, 364, "Solutions technologiques."),
(NULL, 364, "Besoin exprimé par l’individu, la société."),
(NULL, 364, "Evolution technologique (innovation, invention, principe technique, approche environnementale)."),
(NULL, 364, "Algorithmes et programmation."),
(NULL, 364, "Les objets programmables."),

(NULL, 365, "Mouvements."),
(NULL, 365, "Masse et volume."),
(NULL, 365, "Mélanges."),
(NULL, 365, "Propriétés de la matière."),
(NULL, 365, "Conversions d’énergie."),
(NULL, 365, "Électricité."),
(NULL, 365, "Lumière."),

-- 6EME - Arts plastiques

(NULL, 371, "Expérimenter, produire, créer."),
(NULL, 371, "Mettre en œuvre un projet artistique."),
(NULL, 371, "S’exprimer, analyser sa pratique, celle de ses pairs ; établir une relation avec celle des artistes, s’ouvrir à l’altérité."),
(NULL, 371, "Se repérer dans les domaines liés aux arts plastiques, être sensible aux questions de l’art."),

(NULL, 372, "La matérialité de la production plastique et la sensibilité aux constituants de l’œuvre."),
(NULL, 372, "La représentation plastique et les dispositifs de présentations."),
(NULL, 372, "Les fabrications et la relation entre l’objet et l’espace."),

-- 6EME - Éducation musicale

(NULL, 381, "Chanter et interpréter."),
(NULL, 381, "Échanger, partager et argumenter."),
(NULL, 381, "Écouter, comparer et commenter."),
(NULL, 381, "Explorer, imaginer et créer."),

-- 6EME - Éducation physique et sportive

(NULL, 391, "Activités de roule (vélo, roller…)."),
(NULL, 391, "Activités nautiques."),
(NULL, 391, "Alerter en cas de problème."),
(NULL, 391, "Connaitre et respecter les règles de sécurité."),
(NULL, 391, "Parcours d’escalade."),
(NULL, 391, "Parcours d’orientation."),
(NULL, 391, "Réaliser un parcours dans plusieurs environnements inhabituels."),
(NULL, 391, "Savoir Nager."),
(NULL, 391, "Valider l’attestation scolaire du savoir nager (ASSN)."),

(NULL, 392, "Accepter le résultat de la rencontre."),
(NULL, 392, "Assurer différents rôles (joueur, arbitre, observateur)."),
(NULL, 392, "Jeux collectifs avec ballon."),
(NULL, 392, "Jeux de combat."),
(NULL, 392, "Jeux de raquettes."),
(NULL, 392, "Jeux traditionnels."),
(NULL, 392, "Maintenir un engagement moteur."),
(NULL, 392, "Respecter les partenaires, les adversaires et l’arbitre."),
(NULL, 392, "S’organiser pour gagner."),

(NULL, 393, "Activités athlétiques."),
(NULL, 393, "Assumer les rôles de chronométreur et d’observateur."),
(NULL, 393, "Combiner une course, un saut, un lancer."),
(NULL, 393, "Mesurer et analyser une performance."),
(NULL, 393, "Natation."),
(NULL, 393, "Réaliser des efforts et enchainer plusieurs actions motrices."),

(NULL, 394, "Activités gymniques."),
(NULL, 394, "Arts du cirque."),
(NULL, 394, "Danse."),
(NULL, 394, "Filmer une prestation pour la revoir et la faire évoluer."),
(NULL, 394, "Réaliser en petits groupes une séquence acrobatique ou à visée artistique."),
(NULL, 394, "Respecter les prestations des autres et accepter de se produire devant les autres."),

-- 6EME - Enseignement moral et civique

(NULL, 401, "Avoir des droits en tant que personne et respecter ceux des autres : l’exemple du droit à la vie privée."),
(NULL, 401, "Représenter les autres et servir l’intérêt général."),
(NULL, 401, "Respecter des règles et en comprendre la finalité : l’exemple de la laïcité à l’École."),

-- 6EME - Français

(NULL, 411, "Chanter et enchanter le monde : mots et merveilles (poésie)."),
(NULL, 411, "Créer, recréer le monde : récits des origines (récit, fiction)."),
(NULL, 411, "Partir à l’aventure ! (récit, fiction)."),
(NULL, 411, "Rencontrer des monstres : expérience de l’autre, expérience de soi (récit, fiction)."),
(NULL, 411, "Se masquer, jouer, déjouer : ruses en action (théâtre)."),

(NULL, 412, "Écrire à la main de manière fluide et efficace."),
(NULL, 412, "Écrire pour réfléchir, apprendre et mémoriser."),
(NULL, 412, "Produire des écrits variés."),

(NULL, 413, "Acquérir l’orthographe grammaticale."),
(NULL, 413, "Identifier les constituants d’une phrase simple."),
(NULL, 413, "Se repérer dans la phrase complexe."),

(NULL, 414, "Lire à voix haute avec expressivité."),
(NULL, 414, "Lire avec fluidité."),
(NULL, 414, "Lire et comprendre des textes, des documents et des images pour apprendre dans toutes les disciplines."),
(NULL, 414, "Lire et comprendre seul des textes, des documents et des images."),
(NULL, 414, "Lire une œuvre et se l’approprier."),

(NULL, 415, "Dire pour être compris dans toutes les disciplines."),
(NULL, 415, "Écouter pour comprendre."),
(NULL, 415, "Participer à des échanges verbaux."),

(NULL, 416, "Enrichir son vocabulaire dans toutes les disciplines."),
(NULL, 416, "Établir des relations entre les mots."),
(NULL, 416, "Mémoriser l’orthographe des mots."),
(NULL, 416, "Réemployer le vocabulaire étudié."),

-- 6EME - Histoire des arts

(NULL, 421, "Dégager d’une œuvre d’art, par l’observation ou l’écoute, ses principales caractéristiques techniques et formelles."),
(NULL, 421, "Donner un avis argumenté sur ce que représente ou exprime une œuvre d’art."),
(NULL, 421, "Relier des caractéristiques d’une œuvre d’art à des usages ainsi qu’au contexte historique et culturel de sa création."),
(NULL, 421, "Se repérer dans un musée, dans un lieu d’art, un site patrimonial."),

-- 6EME - Histoire et géographie

(NULL, 431, "Comprendre le sens général d’un document."),
(NULL, 431, "Extraire des informations d’un document."),
(NULL, 431, "Identifier le document."),

(NULL, 432, "Organiser son travail dans le cadre d’un groupe."),
(NULL, 432, "Travailler en commun."),
(NULL, 432, "Utiliser les outils numériques dans le travail collectif."),

(NULL, 433, "Littoral industrialo-portuaire, littoral touristique."),

(NULL, 434, "Habiter un espace à forte(s) contrainte(s) naturelle(s) ou / et de grande biodiversité."),
(NULL, 434, "Habiter un espace de faible densité à vocation agricole."),

(NULL, 435, "La ville de demain."),
(NULL, 435, "Les métropoles et leurs habitants."),

(NULL, 436, "La répartition de la population mondiale et ses dynamiques."),
(NULL, 436, "La variété des formes d’occupation spatiale dans le monde."),

(NULL, 437, "Conquêtes, paix romaine et romanisation."),
(NULL, 437, "Des chrétiens dans l’empire."),
(NULL, 437, "Les relations de l’empire romain avec les autres mondes anciens : l’ancienne route de la soie et la Chine des Han."),

(NULL, 438, "La « révolution » néolithique."),
(NULL, 438, "Les débuts de l’humanité."),
(NULL, 438, "Premiers États, premières écritures."),

(NULL, 439, "La naissance du monothéisme juif dans un monde polythéiste."),
(NULL, 439, "Le monde des cités grecques."),
(NULL, 439, "Rome du mythe à l’histoire."),

(NULL, 440, "Écrire pour penser, argumenter, communiquer et échanger."),
(NULL, 440, "Réaliser des productions."),
(NULL, 440, "Reconnaitre un récit historique."),
(NULL, 440, "S’approprier et utiliser un lexique historique et géographique."),
(NULL, 440, "S’exprimer à l’oral."),
(NULL, 440, "Utiliser des cartes."),

(NULL, 441, "Formuler des hypothèses."),
(NULL, 441, "Justifier."),
(NULL, 441, "Poser et se poser des questions."),
(NULL, 441, "Vérifier."),

(NULL, 442, "Connaitre et utiliser différents systèmes d’information."),
(NULL, 442, "Identifier la ressource numérique utilisée."),
(NULL, 442, "Trouver, sélectionner et exploiter des informations dans une ressource numérique."),

(NULL, 443, "Appréhender la notion d’échelle géographique."),
(NULL, 443, "Mémoriser et mobiliser les repères géographiques."),
(NULL, 443, "Nommer et localiser les grands repères géographiques."),

(NULL, 444, "Mémoriser et mobiliser ses repères historiques."),
(NULL, 444, "Ordonner des faits et les situer."),
(NULL, 444, "Situer des grandes périodes historiques."),
(NULL, 444, "Utiliser des documents."),

-- 6EME - Langues vivantes

(NULL, 451, "Niveau A1 Peut reconnaître et transmettre des informations simples (mots ou chiffres) issues de panneaux, annonces, affiches, programmes, dépliants, albums, etc."),
(NULL, 451, "Niveau A1+ Peut relever et transmettre ou traduire des informations simples issues de panneaux, annonces, affiches, programmes, dépliants, albums, etc."),
(NULL, 451, "Niveau A2 Peut transmettre ou traduire les points principaux de conversations ou de textes courts sur des sujets du quotidien."),
(NULL, 451, "Niveau A2+ Peut transmettre des informations pertinentes présentes dans des textes informatifs sur des sujets familiers."),
(NULL, 451, "Niveau B1 Peut transmettre des informations sur des sujets familiers, donner des consignes simples pour organiser une activité ou faire clarifier des positions divergentes."),
(NULL, 451, "Niveau B1+ Peut fournir des explications détaillées, donner des consignes élaborées pour organiser une activité et proposer des solutions simples pour trouver des compromis."),
(NULL, 451, "Niveau B2 Peut gérer une discussion collective et comparer, opposer et synthétiser des informations et points de vue différents. Peut organiser et gérer un travail collectif de façon efficace et agir comme rapporteur d’un groupe."),
(NULL, 451, "Niveau C1 Peut animer un travail d’équipe avec aisance et spontanéité, reformuler des idées abstraites ou agir en intermédiaire dans des situations complexes."),
(NULL, 451, "Niveau C2 Peut arbitrer des conflits de communication et des malentendus culturels, en adaptant son langage et en tenant compte du contexte et des relations entre les personnes impliquées."),

(NULL, 452, "Niveau A1 Peut reconnaître des expressions du quotidien dans une histoire et suivre des consignes simples et habituelles."),
(NULL, 452, "Niveau A1+ Peut comprendre des phrases simples dans des histoires ou sur des sujets du quotidien et suivre des consignes simples et habituelles."),
(NULL, 452, "Niveau A2 Peut comprendre des informations simples dans des histoires ou conversations si le débit est adapté."),
(NULL, 452, "Niveau A2+ Peut comprendre les informations principales dans des conversations, ou reportages si le sujet est familier et le débit adapté."),
(NULL, 452, "Niveau B1 Peut comprendre les points principaux de bulletins d’information et suivre l’action dans des séries ou films."),
(NULL, 452, "Niveau B1+ Peut comprendre les idées principales d’une interview et distinguer les différents points de vue des personnages dans des films ou séries."),
(NULL, 452, "Niveau B2 Peut comprendre la plupart des reportages, films ou séries sur des sujets qui l’intéressent et suivre les argumentations et intentions dans un débat sur un sujet préparé."),
(NULL, 452, "Niveau C1 Peut suivre un discours politique, une présentation scientifique, une pièce de théâtre engagé/un propos militant, des spectacles humoristiques."),
(NULL, 452, "Niveau C2 Peut comprendre sans effort pratiquement toute langue orale."),
(NULL, 452, "Niveau pré-A1 Peut reconnaître des mots familiers, des nombres, des prix, des dates et les jours de la semaine."),

(NULL, 453, "Niveau A1 Peut écrire sous la dictée des phrases très simples, compléter un questionnaire simple ou décrire son environnement familier avec des éléments appris par cœur."),
(NULL, 453, "Niveau A1+ Peut décrire très simplement des personnes, lieux et objets de son environnement familier selon un modèle connu."),
(NULL, 453, "Niveau A2 Peut écrire le début d’une histoire ou en continuer une avec de l’aide. Peut décrire ses impressions de manière simple sur un sujet familier."),
(NULL, 453, "Niveau A2+ Peut rédiger une lettre ou un mail pour décrire son quotidien, raconter ses expériences personnelles ou présenter les étapes d’un projet."),
(NULL, 453, "Niveau B1 Peut rédiger un texte pour raconter une expérience ou un événement de manière structurée, tels un article de blog, une analyse critique de film, etc."),
(NULL, 453, "Niveau B1+ Peut rédiger une critique ou un compte rendu structuré sur un film, une série ou un livre en utilisant un vocabulaire assez étendu."),
(NULL, 453, "Niveau B2 Peut rédiger un texte bien structuré et détaillé tels un essai, une analyse critique, un édito, un argumentaire en faveur d’un projet, une lettre de motivation, etc."),
(NULL, 453, "Niveau C1 Peut rédiger des textes complexes et bien structurés sur des sujets variés, comme des analyses critiques, rapports ou essais en apportant des exemples pertinents pour approfondir son propos et parvenir à une conclusion fondée."),
(NULL, 453, "Niveau C2 Peut écrire des textes élaborés, et fluides, dans un registre approprié selon une structure logique qui aide le destinataire à remarquer les points importants."),
(NULL, 453, "Niveau pré-A1 Peut noter des mots connus sous la dictée."),

(NULL, 454, "Niveau A1 Peut reconnaître des expressions isolées dans des histoires et comprendre des énoncés très simples sur des sujets familiers."),
(NULL, 454, "Niveau A1+ Peut comprendre un texte court et des énoncés simples sur des sujets familiers."),
(NULL, 454, "Niveau A2 Peut comprendre des informations simples dans des textes ou énoncés portant sur des sujets habituels."),
(NULL, 454, "Niveau A2+ Peut comprendre les informations principales dans des textes portant sur des sujets familiers."),
(NULL, 454, "Niveau B1 Peut comprendre les points principaux dans des articles de presse simples et suivre l’intrigue d’histoires courtes et de bandes dessinées."),
(NULL, 454, "Niveau B1+ Peut comprendre les idées et points de vue développés dans un article de presse standard et suivre l’intrigue de romans simples."),
(NULL, 454, "Niveau B2 Peut comprendre des articles longs en distinguant faits et points de vue et lire de la fiction de manière autonome."),
(NULL, 454, "Niveau C1 Peut comprendre des articles complexes, des publications scientifiques, des essais."),
(NULL, 454, "Niveau C2 Peut comprendre sans effort presque toute forme d’écrit."),
(NULL, 454, "Niveau pré-A1 Peut reconnaître des mots familiers accompagnés d’images."),

(NULL, 455, "Niveau A1 Peut utiliser des expressions simples pour se présenter et dire ce qu’il/elle aime ou n’aime pas grâce à du vocabulaire mémorisé."),
(NULL, 455, "Niveau A1+ Peut exprimer ses goûts de manière simple, raconter brièvement une expérience ou une histoire grâce à des mots mémorisés ou reprendre une chanson si les paroles sont simples."),
(NULL, 455, "Niveau A2 Peut décrire des activités quotidiennes, des personnes et lieux, ou parler brièvement de ses projets ou de son parcours. Peut donner son opinion sur des sujets d’intérêt personnel."),
(NULL, 455, "Niveau A2+ Peut décrire, dans un exposé, une journée typique, expliquer ses préférences pour certains loisirs, ou relater ses expériences passées, et exprimer sa préférence pour une activité."),
(NULL, 455, "Niveau B1 Peut raconter une histoire ou faire la présentation orale d’une expérience en détaillant ses impressions et ses choix."),
(NULL, 455, "Niveau B1+ Peut développer une histoire, décrire assez précisément un événement, exprimer clairement ses sentiments et plaider en faveur d’un projet."),
(NULL, 455, "Niveau B2 Peut développer de manière claire et détaillée des sujets variés, parler de ses passions, projets ou expériences en ajoutant des exemples précis et en s’adaptant à son auditoire."),
(NULL, 455, "Niveau C1 Peut analyser dans une présentation orale des questions relevant de domaines variés en développant plusieurs aspects du sujet et en adoptant ton, style et registre à son auditoire."),
(NULL, 455, "Niveau C2 Peut produire un discours élaboré et fluide, structuré de façon logique et attestant d’un engagement susceptible de convaincre l’auditoire."),
(NULL, 455, "Niveau pré-A1 Peut répéter des mots simples vus en classe."),

(NULL, 456, "Niveau A1 Peut poser des questions basiques ou apporter des réponses très simples apprises par cœur."),
(NULL, 456, "Niveau A1+ Peut répondre à des questions simples et en poser dans des situations récurrentes."),
(NULL, 456, "Niveau A2 Peut participer à des conversations courtes sur des sujets préparés."),
(NULL, 456, "Niveau A2+ Peut faire face à des échanges courants ou sur des thématiques connues : poser des questions, répondre et échanger des idées et des renseignements sur des sujets familiers."),
(NULL, 456, "Niveau B1 Peut aborder une conversation sur un sujet familier, poser des questions pour bien comprendre le point de vue des autres et clore une discussion."),
(NULL, 456, "Niveau B1+ Peut participer activement à des échanges sur des sujets connus, reformuler les idées afin de s’assurer de bien comprendre, gérer les interruptions et relancer la conversation de manière appropriée, en maintenant un échange équilibré."),
(NULL, 456, "Niveau B2 Peut participer avec aisance à une conversation sur un sujet connu et exposer ses idées et ses opinions dans un débat."),
(NULL, 456, "Niveau C1 Peut conduire avec aisance et spontanéité un entretien ou une conversation motivés par une intention particulière."),
(NULL, 456, "Niveau C2 Peut participer sans effort à toute conversation, discussion ou débat, y compris dans des situations de tension."),
(NULL, 456, "Niveau pré-A1 Peut écrire des mots connus pour donner une information très simple comme son nom, son adresse, son âge."),

-- 6EME - Mathématiques

(NULL, 461, "Étude de configurations planes."),
(NULL, 461, "La vision dans l’espace."),

(NULL, 462, "Le repérage dans le temps et les durées."),
(NULL, 462, "Les aires."),
(NULL, 462, "Les longueurs."),
(NULL, 462, "Les volumes."),

(NULL, 463, "Identifier une instruction ou une séquence d’instructions."),
(NULL, 463, "Produire et exécuter une séquence d’instructions."),
(NULL, 463, "Programmer la construction d’un chemin simple."),
(NULL, 463, "Répéter à la main une séquence d’instructions pour accomplir une tâche imposée."),

(NULL, 464, "Connaître la définition de la proportionnalité entre deux grandeurs et la mettre en lien avec des expressions de la vie courante."),
(NULL, 464, "Identifier si une situation relève du « modèle » de la proportionnalité."),
(NULL, 464, "Représenter une situation de proportionnalité à l’aide d’un tableau ou de notations symboliques."),
(NULL, 464, "Résoudre un problème de proportionnalité en choisissant une procédure adaptée : propriété de linéarité pour la multiplication ou l’addition, retour à l’unité."),
(NULL, 464, "S’initier à la résolution de problèmes d’échelles."),

(NULL, 465, "Algèbre."),
(NULL, 465, "Les fractions."),
(NULL, 465, "Les nombres entiers et décimaux."),

(NULL, 466, "Les probabilités."),
(NULL, 466, "Organisation et gestion de données."),

-- 6EME - Sciences de la vie et de la terre

(NULL, 471, "Adopter un comportement éthique et responsable."),
(NULL, 471, "Concevoir, créer, réaliser."),
(NULL, 471, "Faire preuve d’esprit critique."),
(NULL, 471, "Mobiliser des outils numériques."),
(NULL, 471, "Pratiquer des démarches scientifiques et technologiques."),
(NULL, 471, "Pratiquer des langages."),
(NULL, 471, "Se situer dans l’espace et dans le temps."),

(NULL, 472, "Conséquences des actions humaines sur l’environnement."),
(NULL, 472, "Écosystème."),
(NULL, 472, "Place des êtres vivants dans les chaînes alimentaires."),
(NULL, 472, "La Terre, une planète active qui abrite la vie."),

(NULL, 473, "Besoins alimentaires et nutrition humaine."),
(NULL, 473, "Production et conservation des aliments."),
(NULL, 473, "Cycle de vie."),
(NULL, 473, "Reproduction et sexualité humaine."),
(NULL, 473, "Biodiversité actuelle et passée."),
(NULL, 473, "Classification du vivant."),
(NULL, 473, "Organisation des êtres vivants."),

(NULL, 474, "Cycle de vie de l’objet technique."),
(NULL, 474, "Notion de contrainte (imperméabilité, poids, autonomie, etc.)."),
(NULL, 474, "Problème technique."),
(NULL, 474, "Processus de réalisation de maquettes."),
(NULL, 474, "Besoins et fonctions techniques."),
(NULL, 474, "Représentation des objets techniques."),
(NULL, 474, "Solutions technologiques."),
(NULL, 474, "Besoin exprimé par l’individu, la société."),
(NULL, 474, "Evolution technologique (innovation, invention, principe technique, approche environnementale)."),
(NULL, 474, "Les objets programmables."),

(NULL, 475, "Mouvements."),
(NULL, 475, "Masse et volume."),
(NULL, 475, "Mélanges."),
(NULL, 475, "Propriétés de la matière."),
(NULL, 475, "Conversions d’énergie."),
(NULL, 475, "Électricité."),
(NULL, 475, "Lumière."),
(NULL, 475, "Transmission de l’information."),

-- 6EME - Sciences et technologie

(NULL, 481, "Adopter un comportement éthique et responsable."),
(NULL, 481, "Concevoir, créer, réaliser."),
(NULL, 481, "Faire preuve d’esprit critique."),
(NULL, 481, "Mobiliser des outils numériques."),
(NULL, 481, "Pratiquer des démarches scientifiques et technologiques."),
(NULL, 481, "Pratiquer des langages."),
(NULL, 481, "Se situer dans l’espace et dans le temps."),

(NULL, 482, "Conséquences des actions humaines sur l’environnement."),
(NULL, 482, "Écosystème."),
(NULL, 482, "Place des êtres vivants dans les chaînes alimentaires."),
(NULL, 482, "La Terre, une planète active qui abrite la vie."),

(NULL, 483, "Besoins alimentaires et nutrition humaine."),
(NULL, 483, "Production et conservation des aliments."),
(NULL, 483, "Cycle de vie."),
(NULL, 483, "Reproduction et sexualité humaine."),
(NULL, 483, "Biodiversité actuelle et passée."),
(NULL, 483, "Classification du vivant."),
(NULL, 483, "Organisation des êtres vivants."),

(NULL, 484, "Cycle de vie de l’objet technique."),
(NULL, 484, "Notion de contrainte (imperméabilité, poids, autonomie, etc.)."),
(NULL, 484, "Problème technique."),
(NULL, 484, "Processus de réalisation de maquettes."),
(NULL, 484, "Besoins et fonctions techniques."),
(NULL, 484, "Représentation des objets techniques."),
(NULL, 484, "Solutions technologiques."),
(NULL, 484, "Besoin exprimé par l’individu, la société."),
(NULL, 484, "Evolution technologique (innovation, invention, principe technique, approche environnementale)."),
(NULL, 484, "Les objets programmables."),

(NULL, 485, "Mouvements."),
(NULL, 485, "Masse et volume."),
(NULL, 485, "Mélanges."),
(NULL, 485, "Propriétés de la matière."),
(NULL, 485, "Conversions d’énergie."),
(NULL, 485, "Électricité."),
(NULL, 485, "Lumière."),
(NULL, 485, "Transmission de l’information."),

-- 5EME - Arts plastiques

(NULL, 491, "Expérimenter, produire, créer."),
(NULL, 491, "Mettre en œuvre un projet artistique."),
(NULL, 491, "S’exprimer, analyser sa pratique, celle de ses pairs."),
(NULL, 491, "Se repérer dans les domaines liés aux arts plastiques, être sensible aux questions de l’art."),

(NULL, 492, "L’œuvre, l’espace, l’auteur, le spectateur."),
(NULL, 492, "La matérialité de l’œuvre ; l’objet et l’œuvre."),
(NULL, 492, "La représentation ; images, réalité et fiction."),

-- 5EME - Éducation aux médias et à l’information

(NULL, 501, "Exploiter l’information de manière raisonnée."),
(NULL, 501, "Produire, communiquer, partager des informations."),
(NULL, 501, "Utiliser les médias de manière responsable."),
(NULL, 501, "Utiliser les médias et les informations de manière autonome."),

-- 5EME - Éducation musicale

(NULL, 511, "Échanger, partager, argumenter et débattre."),
(NULL, 511, "Écouter, comparer et construire une culture musicale commune."),
(NULL, 511, "Explorer, imaginer, créer et produire."),
(NULL, 511, "Réaliser des projets musicaux d’interprétation ou de création."),

-- 5EME - Éducation physique et sportive

(NULL, 521, "Assurer la sécurité de son camarade."),
(NULL, 521, "Canoë-kayak."),
(NULL, 521, "Escalade."),
(NULL, 521, "Gérer ses ressources pour réaliser un parcours."),
(NULL, 521, "Randonnée."),
(NULL, 521, "Réussir un déplacement planifié dans un milieu plus ou moins connu."),
(NULL, 521, "Ski."),
(NULL, 521, "VTT."),

(NULL, 522, "Accepter le résultat de la rencontre et savoir l’analyser."),
(NULL, 522, "Adapter son engagement moteur en fonction de son état physique et du rapport de force."),
(NULL, 522, "Badminton."),
(NULL, 522, "Basket-ball."),
(NULL, 522, "Boxe française."),
(NULL, 522, "Être solidaire de ses partenaires et respectueux de ses adversaires et de l’arbitre."),
(NULL, 522, "Football."),
(NULL, 522, "Handball."),
(NULL, 522, "Jeux traditionnels."),
(NULL, 522, "Judo."),
(NULL, 522, "Lutte."),
(NULL, 522, "Observer et co-arbitrer."),
(NULL, 522, "Réaliser des actions décisives."),
(NULL, 522, "Rugby."),
(NULL, 522, "Tennis de table."),
(NULL, 522, "Volley-ball."),

(NULL, 523, "Aider ses camarades et assumer différents rôles sociaux (juge d’appel, chronométreur…)."),
(NULL, 523, "Courses de haies."),
(NULL, 523, "Demi-fond."),
(NULL, 523, "Gérer son effort, faire des choix pour réaliser la meilleure performance."),
(NULL, 523, "Hauteur."),
(NULL, 523, "Lancers."),
(NULL, 523, "Natation de vitesse."),
(NULL, 523, "Natation longue."),
(NULL, 523, "Planifier et réaliser une épreuve combinée."),
(NULL, 523, "Relais vitesse."),
(NULL, 523, "S’échauffer avant un effort."),
(NULL, 523, "S’engager dans un programme de préparation individuel ou collectif."),
(NULL, 523, "Sauts."),

(NULL, 524, "Accrosport et gymnastique."),
(NULL, 524, "Aérobic."),
(NULL, 524, "Apprécier des prestations."),
(NULL, 524, "Arts du cirque."),
(NULL, 524, "Danse."),
(NULL, 524, "Mobiliser les capacités expressives du corps."),
(NULL, 524, "Participer activement, au sein d’un groupe, à un projet artistique."),

-- 5EME - Enseignement intégré de science et technologie

(NULL, 531, "Concevoir, créer, réaliser."),
(NULL, 531, "Mobiliser les outils numériques."),
(NULL, 531, "Pratiquer des démarches scientifiques et technologiques."),
(NULL, 531, "Pratiquer des langages."),
(NULL, 531, "S’approprier les outils et les méthodes."),
(NULL, 531, "Se situer dans l’espace et le temps."),

(NULL, 532, "Identifier les sources, les transferts, les conversions et les formes d’énergie."),
(NULL, 532, "Réaliser des circuits électriques simples et exploiter les lois de l’électricité."),
(NULL, 532, "Utiliser la conservation de l’énergie."),

(NULL, 533, "Caractériser un mouvement."),
(NULL, 533, "Modéliser une interaction par une force caractérisée par un point d’application, une direction, un sens et une valeur."),

(NULL, 534, "Caractériser différents types de signaux (lumineux, sonores, radio…)."),
(NULL, 534, "Utiliser les propriétés de ces signaux."),

(NULL, 535, "Décrire et expliquer des transformations chimiques."),
(NULL, 535, "Décrire l’organisation de la matière dans l’Univers."),
(NULL, 535, "Décrire la constitution et les états de la matière."),

(NULL, 536, "Envisager ou justifier des comportements responsables face à l’environnement et à la préservation des ressources limitées de la planète."),
(NULL, 536, "Explorer et expliciter certains éléments de météorologie et climatologie."),
(NULL, 536, "Explorer et expliciter certains phénomènes géologiques liés au fonctionnement de la Terre."),
(NULL, 536, "Identifier les principaux impacts de l’action humaine, bénéfices et risques, à la surface de la planète Terre."),

(NULL, 537, "Expliquer quelques processus biologiques impliqués dans le fonctionnement de l’organisme humain, jusqu’au niveau moléculaire : activités musculaire, nerveuse et cardio-vasculaire, activité cérébrale, alimentation et digestion, relations avec le monde microbien, reproduction et sexualité."),
(NULL, 537, "Relier la connaissance de ces processus biologiques aux enjeux liés aux comportements responsables individuels et collectifs en matière de santé."),

(NULL, 538, "Expliquer l’organisation du monde vivant, sa structure et son dynamisme à différentes échelles d’espace et de temps."),
(NULL, 538, "Mettre en relation différents faits et établir des relations de causalité pour expliquer : la nutrition des organismes, la dynamique des populations, la classification du vivant, la biodiversité, la diversité génétique des individus, l’évolution des êtres vivants."),

(NULL, 539, "Imaginer des solutions, matérialiser des idées."),
(NULL, 539, "Réaliser un prototype."),

(NULL, 540, "Écrire, mettre au point et exécuter un programme."),
(NULL, 540, "Fonctionnement d’un réseau informatique."),

(NULL, 541, "Évolution des objets et systèmes."),
(NULL, 541, "Objets communicants et bonnes pratiques."),
(NULL, 541, "Outils de description."),

(NULL, 542, "Fonctionnement et structure d’un objet."),
(NULL, 542, "Utiliser une modélisation, simulation des objets."),

-- 5EME - Enseignement moral et civique

(NULL, 551, "Agir pour l’égalité femmes-hommes et lutter contre les discriminations."),
(NULL, 551, "La solidarité et ses échelles."),

-- 5EME - Français

(NULL, 561, "Adopter les procédés d’écriture qui répondent à la consigne et à l’objectif."),
(NULL, 561, "Communiquer par écrit ses sentiments et ses opinions."),
(NULL, 561, "Écrire pour réfléchir."),
(NULL, 561, "Exploiter des lectures pour enrichir son écrit."),
(NULL, 561, "S’initier à l’argumentation."),

(NULL, 562, "Analyser la phrase complexe."),
(NULL, 562, "Connaitre des notions d’analyse littéraire."),
(NULL, 562, "Connaitre le rôle de la ponctuation."),
(NULL, 562, "Connaitre les différences entre l’oral et l’écrit."),
(NULL, 562, "Maitriser l’usage du vocabulaire."),
(NULL, 562, "Maitriser la phrase simple."),
(NULL, 562, "Maitriser le fonctionnement du verbe."),
(NULL, 562, "Maitriser les accords dans la phrase."),

(NULL, 563, "Analyser une œuvre et repérer ses effets esthétiques."),
(NULL, 563, "Lire des images, des documents et des textes non littéraires."),
(NULL, 563, "Lire des textes littéraires et fréquenter des œuvres d’art."),

(NULL, 564, "Comprendre des messages oraux."),
(NULL, 564, "Exploiter les ressources de la parole."),
(NULL, 564, "Participer à des échanges."),
(NULL, 564, "S’exprimer de façon maitrisée."),

-- 5EME - Histoire des arts

(NULL, 571, "Associer une œuvre à une époque et une civilisation à partir des éléments observés."),
(NULL, 571, "Construire un exposé de quelques minutes sur un petit ensemble d’œuvres ou une problématique artistique."),
(NULL, 571, "Décrire une œuvre d’art par ses dimensions matérielles, formelles, de sens et d’usage, en employant un lexique adapté."),
(NULL, 571, "Proposer une analyse critique simple et une interprétation d’une œuvre."),
(NULL, 571, "Rendre compte de la visite d’un lieu de conservation ou de diffusion artistique ou de la rencontre avec un métier du patrimoine."),

(NULL, 572, "Arts et société à l’époque antique et au haut Moyen-âge."),
(NULL, 572, "De la Belle Epoque aux « années folles » : l’ère des avant-gardes (1870-1930)."),
(NULL, 572, "État, société, et modes de vie (XIIIe-XVIIIe)."),
(NULL, 572, "Formes et circulations artistiques."),
(NULL, 572, "L’art au temps des Lumières et des révolutions."),
(NULL, 572, "Le sacre de l’artiste."),
(NULL, 572, "Les arts à l’ère de la consommation de masse (de 1945 à nos jours)."),
(NULL, 572, "Les arts entre liberté et propagande (1910-1945)."),

-- 5EME - Histoire et géographie

(NULL, 581, "Comprendre le sens général d’un document."),
(NULL, 581, "Confronter un document à ce qu’on peut connaitre par ailleurs du sujet étudié."),
(NULL, 581, "Extraire des informations pertinentes."),
(NULL, 581, "Identifier le document et son point de vue particulier."),
(NULL, 581, "Utiliser ses connaissances pour expliciter, expliquer le document et exercer son esprit critique."),

(NULL, 582, "Adapter son rythme de travail à celui du groupe."),
(NULL, 582, "Défendre ses choix."),
(NULL, 582, "Négocier une solution commune."),
(NULL, 582, "Organiser son travail dans le cadre d’un groupe."),
(NULL, 582, "Utiliser les outils numériques dans le travail collectif."),

(NULL, 583, "L’alimentation dans le monde."),
(NULL, 583, "L’énergie, l’eau : des ressources à ménager et à mieux utiliser."),

(NULL, 584, "La croissance démographique et ses effets."),
(NULL, 584, "Répartition de la richesse et de la pauvreté dans le monde."),

(NULL, 585, "Le changement global et ses principaux effets géographiques régionaux."),
(NULL, 585, "Prévenir les risques industriels et technologiques."),

(NULL, 586, "Byzance et l’Europe carolingienne."),
(NULL, 586, "De la naissance de l’islam à la prise de Bagdad par les Mongols."),

(NULL, 587, "L’affirmation de l’État monarchique dans le Royaume des Capétiens et des Valois."),
(NULL, 587, "L’émergence d’une nouvelle société urbaine."),
(NULL, 587, "L’ordre seigneurial."),

(NULL, 588, "Du Prince de la Renaissance au roi absolu (François Ier, Henri IV, Louis XIV)."),
(NULL, 588, "Humanisme, réformes et conflits religieux."),
(NULL, 588, "Le monde au temps de Charles Quint et Soliman le Magnifique."),

(NULL, 589, "Écrire pour structurer, argumenter et communiquer."),
(NULL, 589, "Réaliser des productions."),
(NULL, 589, "S’approprier et utiliser un lexique historique et géographique."),
(NULL, 589, "S’initier aux techniques d’argumentation."),

(NULL, 590, "Construire des hypothèses d’interprétation de phénomènes historiques ou géographiques."),
(NULL, 590, "Justifier."),
(NULL, 590, "Poser et se poser des questions à propos de situations historiques ou géographiques."),
(NULL, 590, "Vérifier."),

(NULL, 591, "Connaitre et utiliser différents systèmes d’information."),
(NULL, 591, "Exercer son esprit critique sur les données numériques."),
(NULL, 591, "Trouver, sélectionner et exploiter des informations dans une ressource numérique."),
(NULL, 591, "Utiliser des ressources numériques."),
(NULL, 591, "Vérifier l’origine, la source des informations et leur pertinence."),

(NULL, 592, "Nommer et localiser les grands repères géographiques."),
(NULL, 592, "Nommer, localiser et caractériser des espaces."),
(NULL, 592, "Nommer, localiser et caractériser un lieu."),
(NULL, 592, "Situer des lieux et des espaces."),
(NULL, 592, "Utiliser des représentations analogiques et numériques des espaces."),

(NULL, 593, "Identifier des continuités et des ruptures chronologiques."),
(NULL, 593, "Mettre en relation des faits."),
(NULL, 593, "Ordonner des faits les uns par rapport aux autres."),
(NULL, 593, "Situer un fait."),

-- 5EME - Langues vivantes

(NULL, 601, "niveau A1 - Identifier quelques grands repères culturels dans les pays ou régions étudiés."),
(NULL, 601, "niveau A2 - Mobiliser les connaissances culturelles acquises grâce au programme pour décrire des personnages réels ou imaginaires ou pour raconter des faits."),
(NULL, 601, "niveau A2 - Repérer les indices culturels pour comprendre un message."),
(NULL, 601, "niveau B1 - Repérer et comprendre les spécificités culturelles acquises des pays et des régions concernés et les mettre en lien avec sa culture personnelle."),

(NULL, 602, "niveau A1 - Comprendre des mots familiers et des expressions très courantes sur soi-même, sa famille et son environnement."),
(NULL, 602, "niveau A2 - Comprendre une intervention brève si elle est claire et simple."),
(NULL, 602, "niveau B1 - Comprendre les points essentiels d’un message sur un sujet connu exprimé dans une langue claire."),

(NULL, 603, "niveau A1 - Copier un modèle écrit, écrire un court message et renseigner un questionnaire simple."),
(NULL, 603, "niveau A2 - Écrire un texte court et articulé simplement."),
(NULL, 603, "niveau B1 - Rédiger un texte court et construit sur un sujet connu : reformuler, décrire, raconter, expliquer, exprimer son point de vue."),

(NULL, 604, "niveau A1 - Comprendre dans un message des mots familiers et des phrases très simples."),
(NULL, 604, "niveau A2 - Comprendre des textes courts et simples."),
(NULL, 604, "niveau B1 - Comprendre des textes rédigés dans une langue courante et renvoyant à un sujet connu."),

(NULL, 605, "niveau A1 - Avoir un contrôle limité de structures syntaxiques et de formes grammaticales simples appartenant à un répertoire mémorisé."),
(NULL, 605, "niveau A1 - La prononciation d’un répertoire limité d’expressions et de mots mémorisés est compréhensible avec quelque effort pour un locuteur natif."),
(NULL, 605, "niveau A1 - Utiliser des expressions et des phrases simples pour parler de soi et de son environnement immédiat."),
(NULL, 605, "niveau A2 - La prononciation est en général suffisamment claire pour être comprise malgré un net accent étranger."),
(NULL, 605, "niveau A2 - Se présenter brièvement, parler en termes simples de quelqu’un, d’une activité, d’un lieu."),
(NULL, 605, "niveau A2 - Utiliser correctement des structures simples mais commettre encore des erreurs élémentaires."),
(NULL, 605, "niveau B1 - Communiquer avec une correction suffisante. Des erreurs peuvent se produire mais le sens général reste clair."),
(NULL, 605, "niveau B1 - La prononciation est clairement intelligible même si les erreurs peuvent encore survenir occasionnellement."),
(NULL, 605, "niveau B1 - Prendre la parole sur des sujets connus pour reformuler, décrire, raconter, expliquer, exprimer un point de vue."),

(NULL, 606, "niveau A1 - Avoir un contrôle limité de structures syntaxiques et de formes grammaticales simples appartenant à un répertoire mémorisé."),
(NULL, 606, "niveau A1 - Communiquer, de façon simple, avec l’aide de l’interlocuteur."),
(NULL, 606, "niveau A1 - La prononciation d’un répertoire limité d’expressions et de mots mémorisés est compréhensible avec quelque effort pour un locuteur natif."),
(NULL, 606, "niveau A2 - Communiquer de façon simple."),
(NULL, 606, "niveau A2 - La prononciation est en général suffisamment claire pour être comprise malgré un net accent étranger."),
(NULL, 606, "niveau A2 - Utiliser correctement des strutures simples mais commettre encore des erreurs élémentaires."),
(NULL, 606, "niveau B1 - Communiquer avec une correction suffisante dans des contextes familiers. Des erreurs peuvent se produire mais le sens général reste clair."),
(NULL, 606, "niveau B1 - La prononciation est clairement intelligible même si des erreurs peuvent encore survenir occasionnellement."),
(NULL, 606, "niveau B1 - Prendre part spontanément à une conversation sur un sujet connu."),

-- 5EME - Mathématiques

(NULL, 611, "Écrire, mettre au point et exécuter un programme simple."),

(NULL, 612, "Représenter l’espace."),
(NULL, 612, "Utiliser des notions de géométrie plane pour démontrer."),

(NULL, 613, "Calculer avec des grandeurs mesurables ; exprimer les résultats dans les unités adaptées."),
(NULL, 613, "Comprendre l’effet de quelques transformations sur des grandeurs géométriques."),

(NULL, 614, "Comprendre et utiliser les notions de divisibilité et de nombres premiers."),
(NULL, 614, "Utiliser le calcul littéral."),
(NULL, 614, "Utiliser les nombres pour comparer, calculer et résoudre des problèmes."),

(NULL, 615, "Comprendre et utiliser des notions élémentaires de probabilités."),
(NULL, 615, "Comprendre et utiliser la notion de fonction."),
(NULL, 615, "Interpréter, représenter et traiter des données."),
(NULL, 615, "Résoudre des problèmes de proportionnalité."),

-- 5EME - Physique-chimie

(NULL, 621, "Adopter un comportement éthique et responsable."),
(NULL, 621, "Concevoir, créer, réaliser."),
(NULL, 621, "Mobiliser des outils numériques."),
(NULL, 621, "Pratiquer des démarches scientifiques."),
(NULL, 621, "Pratiquer des langages."),
(NULL, 621, "S’approprier des outils et des méthodes."),
(NULL, 621, "Se situer dans l’espace et le temps."),

(NULL, 622, "Identifier les sources, les transferts, les conversions et les formes d’énergie."),
(NULL, 622, "Réaliser des circuits électriques simples et exploiter les lois de l’électricité."),
(NULL, 622, "Utiliser la conservation de l’énergie."),

(NULL, 623, "Caractériser un mouvement."),
(NULL, 623, "Modéliser une interaction par une force caractérisée par un point d’application, une direction, un sens et une valeur."),

(NULL, 624, "Décrire et expliquer des transformations chimiques."),
(NULL, 624, "Décrire l’organisation de la matière dans l’Univers."),
(NULL, 624, "Décrire la constitution et les états de la matière."),

(NULL, 625, "Caractériser différents types de signaux (lumineux, sonores, radio…)."),
(NULL, 625, "Utiliser les propriétés de ces signaux."),

-- 5EME - Sciences de la vie et de la terre

(NULL, 631, "Adopter un comportement éthique et responsable."),
(NULL, 631, "Concevoir, créer, réaliser."),
(NULL, 631, "Mobiliser des outils numériques."),
(NULL, 631, "Pratiquer des démarches scientifiques et technologiques."),
(NULL, 631, "Pratiquer des langages."),
(NULL, 631, "S’approprier des outils et des méthodes."),
(NULL, 631, "Se situer dans l’espace et le temps."),

(NULL, 632, "Envisager ou justifier des comportements responsables face à l’environnement et à la préservation des ressources limitées de la planète."),
(NULL, 632, "Explorer et expliciter certains éléments de météorologie et climatologie."),
(NULL, 632, "Explorer et expliciter certains phénomènes géologiques liés au fonctionnement de la Terre."),
(NULL, 632, "Identifier les principaux impacts de l’action humaine, bénéfices et risques, à la surface de la planète Terre."),

(NULL, 633, "Expliquer quelques processus biologiques impliqués dans le fonctionnement de l’organisme humain, jusqu’au niveau moléculaire : activités musculaire, nerveuse et cardio-vasculaire, activité cérébrale, alimentation et digestion, relations avec le monde microbien, reproduction et sexualité."),
(NULL, 633, "Relier la connaissance de ces processus biologiques aux enjeux liés aux comportements responsables individuels et collectifs en matière de santé."),

(NULL, 634, "Expliquer l’organisation du monde vivant, sa structure et son dynamisme à différentes échelles d’espace et de temps."),
(NULL, 634, "Mettre en relation différents faits et établir des relations de causalité pour expliquer : la nutrition des organismes, la dynamique des populations, la classification du vivant, la biodiversité, la diversité génétique des individus, l’évolution des êtres vivants."),

-- 5EME - Technologie

(NULL, 641, "Concevoir, créer, réaliser."),
(NULL, 641, "Mobiliser les outils numériques."),
(NULL, 641, "Pratiquer des démarches scientifiques et technologiques."),
(NULL, 641, "Pratiquer des langages."),
(NULL, 641, "S’approprier les outils et les méthodes."),
(NULL, 641, "Se situer dans l’espace et le temps."),

(NULL, 642, "Imaginer des solutions, matérialiser des idées."),
(NULL, 642, "Réaliser un prototype."),

(NULL, 643, "Écrire, mettre au point et exécuter un programme."),
(NULL, 643, "Fonctionnement d’un réseau informatique."),

(NULL, 644, "Fonctionnement et structure d’un objet."),
(NULL, 644, "Utiliser une modélisation, simulation des objets."),

(NULL, 645, "Évolution des objets et systèmes."),
(NULL, 645, "Objets communicants et bonnes pratiques."),
(NULL, 645, "Outils de description."),

-- 4EME - Arts plastiques

(NULL, 651, "Expérimenter, produire, créer."),
(NULL, 651, "Mettre en œuvre un projet artistique."),
(NULL, 651, "S’exprimer, analyser sa pratique, celle de ses pairs."),
(NULL, 651, "Se repérer dans les domaines liés aux arts plastiques, être sensible aux questions de l’art."),

(NULL, 652, "L’œuvre, l’espace, l’auteur, le spectateur."),
(NULL, 652, "La matérialité de l’œuvre ; l’objet et l’œuvre."),
(NULL, 652, "La représentation ; images, réalité et fiction."),

-- 4EME - Éducation aux médias et à l’information

(NULL, 661, "Exploiter l’information de manière raisonnée."),
(NULL, 661, "Produire, communiquer, partager des informations."),
(NULL, 661, "Utiliser les médias de manière responsable."),

-- 4EME - Éducation musicale

(NULL, 671, "Échanger, partager, argumenter et débattre."),
(NULL, 671, "Écouter, comparer et construire une culture musicale commune."),
(NULL, 671, "Explorer, imaginer, créer et produire."),
(NULL, 671, "Réaliser des projets musicaux d’interprétation ou de création."),

-- 4EME - Éducation physique et sportive

(NULL, 681, "Assurer la sécurité de son camarade."),
(NULL, 681, "Canoë-kayak."),
(NULL, 681, "Escalade."),
(NULL, 681, "Gérer ses ressources pour réaliser un parcours."),
(NULL, 681, "Randonnée."),
(NULL, 681, "Réussir un déplacement planifié dans un milieu plus ou moins connu."),
(NULL, 681, "Ski."),
(NULL, 681, "VTT."),

(NULL, 682, "Accepter le résultat de la rencontre et savoir l’analyser."),
(NULL, 682, "Adapter son engagement moteur en fonction de son état physique et du rapport de force."),
(NULL, 682, "Badminton."),
(NULL, 682, "Basket-ball."),
(NULL, 682, "Boxe française."),
(NULL, 682, "Être solidaire de ses partenaires et respectueux de ses adversaires et de l’arbitre."),
(NULL, 682, "Football."),
(NULL, 682, "Handball."),
(NULL, 682, "Jeux traditionnels."),
(NULL, 682, "Judo."),
(NULL, 682, "Lutte."),
(NULL, 682, "Observer et co-arbitrer."),
(NULL, 682, "Réaliser des actions décisives."),
(NULL, 682, "Rugby."),
(NULL, 682, "Tennis de table."),
(NULL, 682, "Volley-ball."),

(NULL, 683, "Aider ses camarades et assumer différents rôles sociaux (juge d’appel, chronométreur…)."),
(NULL, 683, "Courses de haies."),
(NULL, 683, "Demi-fond."),
(NULL, 683, "Gérer son effort, faire des choix pour réaliser la meilleure performance."),
(NULL, 683, "Hauteur."),
(NULL, 683, "Lancers."),
(NULL, 683, "Natation de vitesse."),
(NULL, 683, "Natation longue."),
(NULL, 683, "Planifier et réaliser une épreuve combinée."),
(NULL, 683, "Relais vitesse."),
(NULL, 683, "S’échauffer avant un effort."),
(NULL, 683, "S’engager dans un programme de préparation individuel ou collectif."),
(NULL, 683, "Sauts."),

(NULL, 684, "Accrosport et gymnastique."),
(NULL, 684, "Aérobic."),
(NULL, 684, "Apprécier des prestations."),
(NULL, 684, "Arts du cirque."),
(NULL, 684, "Danse."),
(NULL, 684, "Mobiliser les capacités expressives du corps."),
(NULL, 684, "Participer activement, au sein d’un groupe, à un projet artistique."),

-- 4EME - Enseignement intégré de science et technologie

(NULL, 691, "Concevoir, créer, réaliser."),
(NULL, 691, "Mobiliser les outils numériques."),
(NULL, 691, "Pratiquer des démarches scientifiques et technologiques."),
(NULL, 691, "Pratiquer des langages."),
(NULL, 691, "S’approprier les outils et les méthodes."),
(NULL, 691, "Se situer dans l’espace et le temps."),

(NULL, 692, "Identifier les sources, les transferts, les conversions et les formes d’énergie."),
(NULL, 692, "Réaliser des circuits électriques simples et exploiter les lois de l’électricité."),
(NULL, 692, "Utiliser la conservation de l’énergie."),

(NULL, 693, "Caractériser un mouvement."),
(NULL, 693, "Modéliser une interaction par une force caractérisée par un point d’application, une direction, un sens et une valeur."),

(NULL, 694, "Caractériser différents types de signaux (lumineux, sonores, radio…)."),
(NULL, 694, "Utiliser les propriétés de ces signaux."),

(NULL, 695, "Décrire et expliquer des transformations chimiques."),
(NULL, 695, "Décrire l’organisation de la matière dans l’Univers."),
(NULL, 695, "Décrire la constitution et les états de la matière."),

(NULL, 696, "Envisager ou justifier des comportements responsables face à l’environnement et à la préservation des ressources limitées de la planète."),
(NULL, 696, "Explorer et expliciter certains éléments de météorologie et climatologie."),
(NULL, 696, "Explorer et expliciter certains phénomènes géologiques liés au fonctionnement de la Terre."),
(NULL, 696, "Identifier les principaux impacts de l’action humaine, bénéfices et risques, à la surface de la planète Terre."),

(NULL, 697, "Expliquer quelques processus biologiques impliqués dans le fonctionnement de l’organisme humain, jusqu’au niveau moléculaire : activités musculaire, nerveuse et cardio-vasculaire, activité cérébrale, alimentation et digestion, relations avec le monde microbien, reproduction et sexualité."),
(NULL, 697, "Relier la connaissance de ces processus biologiques aux enjeux liés aux comportements responsables individuels et collectifs en matière de santé."),

(NULL, 698, "Expliquer l’organisation du monde vivant, sa structure et son dynamisme à différentes échelles d’espace et de temps."),
(NULL, 698, "Mettre en relation différents faits et établir des relations de causalité pour expliquer : la nutrition des organismes, la dynamique des populations, la classification du vivant, la biodiversité, la diversité génétique des individus, l’évolution des êtres vivants."),

(NULL, 699, "Imaginer des solutions, matérialiser des idées."),
(NULL, 699, "Réaliser un prototype."),

(NULL, 700, "Écrire, mettre au point et exécuter un programme."),
(NULL, 700, "Fonctionnement d’un réseau informatique."),

(NULL, 701, "Évolution des objets et systèmes."),
(NULL, 701, "Objets communicants et bonnes pratiques."),
(NULL, 701, "Outils de description."),

(NULL, 702, "Fonctionnement et structure d’un objet."),
(NULL, 702, "Utiliser une modélisation, simulation des objets."),

-- 4EME - Enseignement moral et civique

(NULL, 711, "Défendre le cadre démocratique : sécurité et défense nationale."),
(NULL, 711, "L’État de droit et les libertés."),

-- 4EME - Français

(NULL, 721, "Adopter les procédés d’écriture qui répondent à la consigne et à l’objectif."),
(NULL, 721, "Communiquer par écrit ses sentiments et ses opinions."),
(NULL, 721, "Écrire pour réfléchir."),
(NULL, 721, "Exploiter des lectures pour enrichir son écrit."),
(NULL, 721, "S’initier à l’argumentation."),

(NULL, 722, "Analyser la phrase complexe."),
(NULL, 722, "Connaitre des notions d’analyse littéraire."),
(NULL, 722, "Connaitre le rôle de la ponctuation."),
(NULL, 722, "Connaitre les différences entre l’oral et l’écrit."),
(NULL, 722, "Maitriser l’usage du vocabulaire."),
(NULL, 722, "Maitriser la phrase simple."),
(NULL, 722, "Maitriser le fonctionnement du verbe."),
(NULL, 722, "Maitriser les accords dans la phrase."),

(NULL, 723, "Analyser une œuvre et repérer ses effets esthétiques."),
(NULL, 723, "Lire des images, des documents et des textes non littéraires."),
(NULL, 723, "Lire des textes littéraires et fréquenter des œuvres d’art."),

(NULL, 724, "Comprendre des messages oraux."),
(NULL, 724, "Exploiter les ressources de la parole."),
(NULL, 724, "Participer à des échanges."),
(NULL, 724, "S’exprimer de façon maitrisée."),

-- 4EME - Histoire des arts

(NULL, 731, "Associer une œuvre à une époque et une civilisation à partir des éléments observés."),
(NULL, 731, "Construire un exposé de quelques minutes sur un petit ensemble d’œuvres ou une problématique artistique."),
(NULL, 731, "Décrire une œuvre d’art par ses dimensions matérielles, formelles, de sens et d’usage, en employant un lexique adapté."),
(NULL, 731, "Proposer une analyse critique simple et une interprétation d’une œuvre."),
(NULL, 731, "Rendre compte de la visite d’un lieu de conservation ou de diffusion artistique ou de la rencontre avec un métier du patrimoine."),

(NULL, 732, "Arts et société à l’époque antique et au haut Moyen-âge."),
(NULL, 732, "De la Belle Epoque aux « années folles » : l’ère des avant-gardes (1870-1930)."),
(NULL, 732, "État, société, et modes de vie (XIIIe-XVIIIe)."),
(NULL, 732, "Formes et circulations artistiques."),
(NULL, 732, "L’art au temps des Lumières et des révolutions."),
(NULL, 732, "Le sacre de l’artiste."),
(NULL, 732, "Les arts à l’ère de la consommation de masse (de 1945 à nos jours)."),
(NULL, 732, "Les arts entre liberté et propagande (1910-1945)."),

-- 4EME - Histoire et géographie

(NULL, 741, "Comprendre le sens général d’un document."),
(NULL, 741, "Confronter un document à ce qu’on peut connaitre par ailleurs du sujet étudié."),
(NULL, 741, "Extraire des informations pertinentes."),
(NULL, 741, "Identifier le document et son point de vue particulier."),
(NULL, 741, "Utiliser ses connaissances pour expliciter, expliquer le document et exercer son esprit critique."),

(NULL, 742, "Adapter son rythme de travail à celui du groupe."),
(NULL, 742, "Défendre ses choix."),
(NULL, 742, "Négocier une solution commune."),
(NULL, 742, "Organiser son travail dans le cadre d’un groupe."),
(NULL, 742, "Utiliser les outils numériques dans le travail collectif."),

(NULL, 743, "L’adaptation du territoire des États-Unis aux nouvelles conditions de la mondialisation."),
(NULL, 743, "Les dynamiques d’un grand ensemble géographique africain."),
(NULL, 743, "Mers et Océans : un monde maritimisé."),

(NULL, 744, "Des villes inégalement connectées aux réseaux de la mondialisation."),
(NULL, 744, "Espace et paysages de l’urbanisation."),

(NULL, 745, "Le tourisme et ses espaces."),
(NULL, 745, "Un monde de migrants."),

(NULL, 746, "Conquêtes et sociétés coloniales."),
(NULL, 746, "L’Europe de la « révolution industrielle »."),

(NULL, 747, "Bourgeoisies marchandes, négoces internationaux, traites négrières et esclavage au XVIIIe siècle."),
(NULL, 747, "L’Europe des Lumières."),
(NULL, 747, "La Révolution française et l’Empire : nouvel ordre politique et société révolutionnée en France et en Europe."),

(NULL, 748, "Conditions féminines dans une société en mutation."),
(NULL, 748, "La Troisième République."),
(NULL, 748, "Une difficile conquête : voter de 1815 à 1870."),

(NULL, 749, "Écrire pour structurer, argumenter et communiquer."),
(NULL, 749, "Réaliser des productions."),
(NULL, 749, "S’approprier et utiliser un lexique historique et géographique."),
(NULL, 749, "S’initier aux techniques d’argumentation."),

(NULL, 750, "Construire des hypothèses d’interprétation de phénomènes historiques ou géographiques."),
(NULL, 750, "Justifier."),
(NULL, 750, "Poser et se poser des questions à propos de situations historiques ou géographiques."),
(NULL, 750, "Vérifier."),

(NULL, 751, "Connaitre et utiliser différents systèmes d’information."),
(NULL, 751, "Exercer son esprit critique sur les données numériques."),
(NULL, 751, "Trouver, sélectionner et exploiter des informations dans une ressource numérique."),
(NULL, 751, "Utiliser des ressources numériques."),
(NULL, 751, "Vérifier l’origine, la source des informations et leur pertinence."),

(NULL, 752, "Nommer et localiser les grands repères géographiques."),
(NULL, 752, "Nommer, localiser et caractériser des espaces."),
(NULL, 752, "Nommer, localiser et caractériser un lieu."),
(NULL, 752, "Situer des lieux et des espaces."),
(NULL, 752, "Utiliser des représentations analogiques et numériques des espaces."),

(NULL, 753, "Identifier des continuités et des ruptures chronologiques."),
(NULL, 753, "Mettre en relation des faits."),
(NULL, 753, "Ordonner des faits les uns par rapport aux autres."),
(NULL, 753, "Situer un fait."),

-- 4EME - Langues vivantes

(NULL, 761, "niveau A1 - Identifier quelques grands repères culturels dans les pays ou régions étudiés."),
(NULL, 761, "niveau A2 - Mobiliser les connaissances culturelles acquises grâce au programme pour décrire des personnages réels ou imaginaires ou pour raconter des faits."),
(NULL, 761, "niveau A2 - Repérer les indices culturels pour comprendre un message."),
(NULL, 761, "niveau B1 - Repérer et comprendre les spécificités culturelles acquises des pays et des régions concernés et les mettre en lien avec sa culture personnelle."),

(NULL, 762, "niveau A1 - Comprendre des mots familiers et des expressions très courantes sur soi-même, sa famille et son environnement."),
(NULL, 762, "niveau A2 - Comprendre une intervention brève si elle est claire et simple."),
(NULL, 762, "niveau B1 - Comprendre les points essentiels d’un message sur un sujet connu exprimé dans une langue claire."),

(NULL, 763, "niveau A1 - Copier un modèle écrit, écrire un court message et renseigner un questionnaire simple."),
(NULL, 763, "niveau A2 - Écrire un texte court et articulé simplement."),
(NULL, 763, "niveau B1 - Rédiger un texte court et construit sur un sujet connu : reformuler, décrire, raconter, expliquer, exprimer son point de vue."),

(NULL, 764, "niveau A1 - Comprendre dans un message des mots familiers et des phrases très simples."),
(NULL, 764, "niveau A2 - Comprendre des textes courts et simples."),
(NULL, 764, "niveau B1 - Comprendre des textes rédigés dans une langue courante et renvoyant à un sujet connu."),

(NULL, 765, "niveau A1 - Avoir un contrôle limité de structures syntaxiques et de formes grammaticales simples appartenant à un répertoire mémorisé."),
(NULL, 765, "niveau A1 - La prononciation d’un répertoire limité d’expressions et de mots mémorisés est compréhensible avec quelque effort pour un locuteur natif."),
(NULL, 765, "niveau A1 - Utiliser des expressions et des phrases simples pour parler de soi et de son environnement immédiat."),
(NULL, 765, "niveau A2 - La prononciation est en général suffisamment claire pour être comprise malgré un net accent étranger."),
(NULL, 765, "niveau A2 - Se présenter brièvement, parler en termes simples de quelqu’un, d’une activité, d’un lieu."),
(NULL, 765, "niveau A2 - Utiliser correctement des structures simples mais commettre encore des erreurs élémentaires."),
(NULL, 765, "niveau B1 - Communiquer avec une correction suffisante. Des erreurs peuvent se produire mais le sens général reste clair."),
(NULL, 765, "niveau B1 - La prononciation est clairement intelligible même si les erreurs peuvent encore survenir occasionnellement."),
(NULL, 765, "niveau B1 - Prendre la parole sur des sujets connus pour reformuler, décrire, raconter, expliquer, exprimer un point de vue."),

(NULL, 766, "niveau A1 - Avoir un contrôle limité de structures syntaxiques et de formes grammaticales simples appartenant à un répertoire mémorisé."),
(NULL, 766, "niveau A1 - Communiquer, de façon simple, avec l’aide de l’interlocuteur."),
(NULL, 766, "niveau A1 - La prononciation d’un répertoire limité d’expressions et de mots mémorisés est compréhensible avec quelque effort pour un locuteur natif."),
(NULL, 766, "niveau A2 - Communiquer de façon simple."),
(NULL, 766, "niveau A2 - La prononciation est en général suffisamment claire pour être comprise malgré un net accent étranger."),
(NULL, 766, "niveau A2 - Utiliser correctement des strutures simples mais commettre encore des erreurs élémentaires."),
(NULL, 766, "niveau B1 - Communiquer avec une correction suffisante dans des contextes familiers. Des erreurs peuvent se produire mais le sens général reste clair."),
(NULL, 766, "niveau B1 - La prononciation est clairement intelligible même si des erreurs peuvent encore survenir occasionnellement."),
(NULL, 766, "niveau B1 - Prendre part spontanément à une conversation sur un sujet connu."),

-- 4EME - Mathématiques

(NULL, 771, "Écrire, mettre au point et exécuter un programme simple."),

(NULL, 772, "Représenter l’espace."),
(NULL, 772, "Utiliser des notions de géométrie plane pour démontrer."),

(NULL, 773, "Calculer avec des grandeurs mesurables ; exprimer les résultats dans les unités adaptées."),
(NULL, 773, "Comprendre l’effet de quelques transformations sur des grandeurs géométriques."),

(NULL, 774, "Comprendre et utiliser les notions de divisibilité et de nombres premiers."),
(NULL, 774, "Utiliser le calcul littéral."),
(NULL, 774, "Utiliser les nombres pour comparer, calculer et résoudre des problèmes."),

(NULL, 775, "Comprendre et utiliser des notions élémentaires de probabilités."),
(NULL, 775, "Comprendre et utiliser la notion de fonction."),
(NULL, 775, "Interpréter, représenter et traiter des données."),
(NULL, 775, "Résoudre des problèmes de proportionnalité."),

-- 4EME - Physique-chimie

(NULL, 781, "Adopter un comportement éthique et responsable."),
(NULL, 781, "Concevoir, créer, réaliser."),
(NULL, 781, "Mobiliser des outils numériques."),
(NULL, 781, "Pratiquer des démarches scientifiques."),
(NULL, 781, "Pratiquer des langages."),
(NULL, 781, "S’approprier des outils et des méthodes."),
(NULL, 781, "Se situer dans l’espace et le temps."),

(NULL, 782, "Identifier les sources, les transferts, les conversions et les formes d’énergie."),
(NULL, 782, "Réaliser des circuits électriques simples et exploiter les lois de l’électricité."),
(NULL, 782, "Utiliser la conservation de l’énergie."),

(NULL, 783, "Caractériser un mouvement."),
(NULL, 783, "Modéliser une interaction par une force caractérisée par un point d’application, une direction, un sens et une valeur."),

(NULL, 784, "Décrire et expliquer des transformations chimiques."),
(NULL, 784, "Décrire l’organisation de la matière dans l’Univers."),
(NULL, 784, "Décrire la constitution et les états de la matière."),

(NULL, 785, "Caractériser différents types de signaux (lumineux, sonores, radio…)."),
(NULL, 785, "Utiliser les propriétés de ces signaux."),

-- 4EME - Sciences de la vie et de la terre

(NULL, 791, "Adopter un comportement éthique et responsable."),
(NULL, 791, "Concevoir, créer, réaliser."),
(NULL, 791, "Mobiliser des outils numériques."),
(NULL, 791, "Pratiquer des démarches scientifiques et technologiques."),
(NULL, 791, "Pratiquer des langages."),
(NULL, 791, "S’approprier des outils et des méthodes."),
(NULL, 791, "Se situer dans l’espace et le temps."),

(NULL, 792, "Envisager ou justifier des comportements responsables face à l’environnement et à la préservation des ressources limitées de la planète."),
(NULL, 792, "Explorer et expliciter certains éléments de météorologie et climatologie."),
(NULL, 792, "Explorer et expliciter certains phénomènes géologiques liés au fonctionnement de la Terre."),
(NULL, 792, "Identifier les principaux impacts de l’action humaine, bénéfices et risques, à la surface de la planète Terre."),

(NULL, 793, "Expliquer quelques processus biologiques impliqués dans le fonctionnement de l’organisme humain, jusqu’au niveau moléculaire : activités musculaire, nerveuse et cardio-vasculaire, activité cérébrale, alimentation et digestion, relations avec le monde microbien, reproduction et sexualité."),
(NULL, 793, "Relier la connaissance de ces processus biologiques aux enjeux liés aux comportements responsables individuels et collectifs en matière de santé."),

(NULL, 794, "Expliquer l’organisation du monde vivant, sa structure et son dynamisme à différentes échelles d’espace et de temps."),
(NULL, 794, "Mettre en relation différents faits et établir des relations de causalité pour expliquer : la nutrition des organismes, la dynamique des populations, la classification du vivant, la biodiversité, la diversité génétique des individus, l’évolution des êtres vivants."),

-- 4EME - Technologie

(NULL, 801, "Concevoir, créer, réaliser."),
(NULL, 801, "Mobiliser les outils numériques."),
(NULL, 801, "Pratiquer des démarches scientifiques et technologiques."),
(NULL, 801, "Pratiquer des langages."),
(NULL, 801, "S’approprier les outils et les méthodes."),
(NULL, 801, "Se situer dans l’espace et le temps."),

(NULL, 802, "Imaginer des solutions, matérialiser des idées."),
(NULL, 802, "Réaliser un prototype."),

(NULL, 803, "Écrire, mettre au point et exécuter un programme."),
(NULL, 803, "Fonctionnement d’un réseau informatique."),

(NULL, 804, "Fonctionnement et structure d’un objet."),
(NULL, 804, "Utiliser une modélisation, simulation des objets."),

(NULL, 805, "Évolution des objets et systèmes."),
(NULL, 805, "Objets communicants et bonnes pratiques."),
(NULL, 805, "Outils de description."),

-- 3EME - Arts plastiques

(NULL, 811, "Expérimenter, produire, créer."),
(NULL, 811, "Mettre en œuvre un projet artistique."),
(NULL, 811, "S’exprimer, analyser sa pratique, celle de ses pairs."),
(NULL, 811, "Se repérer dans les domaines liés aux arts plastiques, être sensible aux questions de l’art."),

(NULL, 812, "L’œuvre, l’espace, l’auteur, le spectateur."),
(NULL, 812, "La matérialité de l’œuvre ; l’objet et l’œuvre."),
(NULL, 812, "La représentation ; images, réalité et fiction."),

-- 3EME - Éducation aux médias et à l’information

(NULL, 821, "Exploiter l’information de manière raisonnée."),
(NULL, 821, "Produire, communiquer, partager des informations."),
(NULL, 821, "Utiliser les médias de manière responsable."),

-- 3EME - Éducation musicale

(NULL, 831, "Échanger, partager, argumenter et débattre."),
(NULL, 831, "Écouter, comparer et construire une culture musicale commune."),
(NULL, 831, "Explorer, imaginer, créer et produire."),
(NULL, 831, "Réaliser des projets musicaux d’interprétation ou de création."),

-- 3EME - Éducation physique et sportive

(NULL, 841, "Assurer la sécurité de son camarade."),
(NULL, 841, "Canoë-kayak."),
(NULL, 841, "Escalade."),
(NULL, 841, "Gérer ses ressources pour réaliser un parcours."),
(NULL, 841, "Randonnée."),
(NULL, 841, "Réussir un déplacement planifié dans un milieu plus ou moins connu."),
(NULL, 841, "Ski."),
(NULL, 841, "VTT."),

(NULL, 842, "Accepter le résultat de la rencontre et savoir l’analyser."),
(NULL, 842, "Adapter son engagement moteur en fonction de son état physique et du rapport de force."),
(NULL, 842, "Badminton."),
(NULL, 842, "Basket-ball."),
(NULL, 842, "Boxe française."),
(NULL, 842, "Être solidaire de ses partenaires et respectueux de ses adversaires et de l’arbitre."),
(NULL, 842, "Football."),
(NULL, 842, "Handball."),
(NULL, 842, "Jeux traditionnels."),
(NULL, 842, "Judo."),
(NULL, 842, "Lutte."),
(NULL, 842, "Observer et co-arbitrer."),
(NULL, 842, "Réaliser des actions décisives."),
(NULL, 842, "Rugby."),
(NULL, 842, "Tennis de table."),
(NULL, 842, "Volley-ball."),

(NULL, 843, "Aider ses camarades et assumer différents rôles sociaux (juge d’appel, chronométreur…)."),
(NULL, 843, "Courses de haies."),
(NULL, 843, "Demi-fond."),
(NULL, 843, "Gérer son effort, faire des choix pour réaliser la meilleure performance."),
(NULL, 843, "Hauteur."),
(NULL, 843, "Lancers."),
(NULL, 843, "Natation de vitesse."),
(NULL, 843, "Natation longue."),
(NULL, 843, "Planifier et réaliser une épreuve combinée."),
(NULL, 843, "Relais vitesse."),
(NULL, 843, "S’échauffer avant un effort."),
(NULL, 843, "S’engager dans un programme de préparation individuel ou collectif."),
(NULL, 843, "Sauts."),

(NULL, 844, "Accrosport et gymnastique."),
(NULL, 844, "Aérobic."),
(NULL, 844, "Apprécier des prestations."),
(NULL, 844, "Arts du cirque."),
(NULL, 844, "Danse."),
(NULL, 844, "Mobiliser les capacités expressives du corps."),
(NULL, 844, "Participer activement, au sein d’un groupe, à un projet artistique."),

-- 3EME - Enseignement intégré de science et technologie

(NULL, 851, "Concevoir, créer, réaliser."),
(NULL, 851, "Mobiliser les outils numériques."),
(NULL, 851, "Pratiquer des démarches scientifiques et technologiques."),
(NULL, 851, "Pratiquer des langages."),
(NULL, 851, "S’approprier les outils et les méthodes."),
(NULL, 851, "Se situer dans l’espace et le temps."),

(NULL, 852, "Identifier les sources, les transferts, les conversions et les formes d’énergie."),
(NULL, 852, "Réaliser des circuits électriques simples et exploiter les lois de l’électricité."),
(NULL, 852, "Utiliser la conservation de l’énergie."),

(NULL, 853, "Caractériser un mouvement."),
(NULL, 853, "Modéliser une interaction par une force caractérisée par un point d’application, une direction, un sens et une valeur."),

(NULL, 854, "Caractériser différents types de signaux (lumineux, sonores, radio…)."),
(NULL, 854, "Utiliser les propriétés de ces signaux."),

(NULL, 855, "Décrire et expliquer des transformations chimiques."),
(NULL, 855, "Décrire l’organisation de la matière dans l’Univers."),
(NULL, 855, "Décrire la constitution et les états de la matière."),

(NULL, 856, "Envisager ou justifier des comportements responsables face à l’environnement et à la préservation des ressources limitées de la planète."),
(NULL, 856, "Explorer et expliciter certains éléments de météorologie et climatologie."),
(NULL, 856, "Explorer et expliciter certains phénomènes géologiques liés au fonctionnement de la Terre."),
(NULL, 856, "Identifier les principaux impacts de l’action humaine, bénéfices et risques, à la surface de la planète Terre."),

(NULL, 857, "Expliquer quelques processus biologiques impliqués dans le fonctionnement de l’organisme humain, jusqu’au niveau moléculaire : activités musculaire, nerveuse et cardio-vasculaire, activité cérébrale, alimentation et digestion, relations avec le monde microbien, reproduction et sexualité."),
(NULL, 857, "Relier la connaissance de ces processus biologiques aux enjeux liés aux comportements responsables individuels et collectifs en matière de santé."),

(NULL, 858, "Expliquer l’organisation du monde vivant, sa structure et son dynamisme à différentes échelles d’espace et de temps."),
(NULL, 858, "Mettre en relation différents faits et établir des relations de causalité pour expliquer : la nutrition des organismes, la dynamique des populations, la classification du vivant, la biodiversité, la diversité génétique des individus, l’évolution des êtres vivants."),

(NULL, 859, "Imaginer des solutions, matérialiser des idées."),
(NULL, 859, "Réaliser un prototype."),

(NULL, 860, "Écrire, mettre au point et exécuter un programme."),
(NULL, 860, "Fonctionnement d’un réseau informatique."),

(NULL, 861, "Évolution des objets et systèmes."),
(NULL, 861, "Objets communicants et bonnes pratiques."),
(NULL, 861, "Outils de description."),

(NULL, 862, "Fonctionnement et structure d’un objet."),
(NULL, 862, "Utiliser une modélisation, simulation des objets."),

-- 3EME - Enseignement moral et civique

(NULL, 871, "Les acteurs du jeu démocratique et leur engagement (1) : l’opinion."),
(NULL, 871, "Les acteurs du jeu démocratique et leur engagement (2) : l’engagement collectif."),
(NULL, 871, "Les règles du jeu démocratique."),

-- 3EME - Français

(NULL, 881, "Adopter les procédés d’écriture qui répondent à la consigne et à l’objectif."),
(NULL, 881, "Communiquer par écrit ses sentiments et ses opinions."),
(NULL, 881, "Écrire pour réfléchir."),
(NULL, 881, "Exploiter des lectures pour enrichir son écrit."),
(NULL, 881, "S’initier à l’argumentation."),

(NULL, 882, "Analyser la phrase complexe."),
(NULL, 882, "Connaitre des notions d’analyse littéraire."),
(NULL, 882, "Connaitre le rôle de la ponctuation."),
(NULL, 882, "Connaitre les différences entre l’oral et l’écrit."),
(NULL, 882, "Maitriser l’usage du vocabulaire."),
(NULL, 882, "Maitriser la phrase simple."),
(NULL, 882, "Maitriser le fonctionnement du verbe."),
(NULL, 882, "Maitriser les accords dans la phrase."),

(NULL, 883, "Analyser une œuvre et repérer ses effets esthétiques."),
(NULL, 883, "Lire des images, des documents et des textes non littéraires."),
(NULL, 883, "Lire des textes littéraires et fréquenter des œuvres d’art."),

(NULL, 884, "Comprendre des messages oraux."),
(NULL, 884, "Exploiter les ressources de la parole."),
(NULL, 884, "Participer à des échanges."),
(NULL, 884, "S’exprimer de façon maitrisée."),

-- 3EME - Histoire des arts

(NULL, 891, "Associer une œuvre à une époque et une civilisation à partir des éléments observés."),
(NULL, 891, "Construire un exposé de quelques minutes sur un petit ensemble d’œuvres ou une problématique artistique."),
(NULL, 891, "Décrire une œuvre d’art par ses dimensions matérielles, formelles, de sens et d’usage, en employant un lexique adapté."),
(NULL, 891, "Proposer une analyse critique simple et une interprétation d’une œuvre."),
(NULL, 891, "Rendre compte de la visite d’un lieu de conservation ou de diffusion artistique ou de la rencontre avec un métier du patrimoine."),

(NULL, 892, "Arts et société à l’époque antique et au haut Moyen-âge."),
(NULL, 892, "De la Belle Epoque aux « années folles » : l’ère des avant-gardes (1870-1930)."),
(NULL, 892, "État, société, et modes de vie (XIIIe-XVIIIe)."),
(NULL, 892, "Formes et circulations artistiques."),
(NULL, 892, "L’art au temps des Lumières et des révolutions."),
(NULL, 892, "Le sacre de l’artiste."),
(NULL, 892, "Les arts à l’ère de la consommation de masse (de 1945 à nos jours)."),
(NULL, 892, "Les arts entre liberté et propagande (1910-1945)."),

-- 3EME - Histoire et géographie

(NULL, 901, "Comprendre le sens général d’un document."),
(NULL, 901, "Confronter un document à ce qu’on peut connaitre par ailleurs du sujet étudié."),
(NULL, 901, "Extraire des informations pertinentes."),
(NULL, 901, "Identifier le document et son point de vue particulier."),
(NULL, 901, "Utiliser ses connaissances pour expliciter, expliquer le document et exercer son esprit critique."),

(NULL, 902, "Adapter son rythme de travail à celui du groupe."),
(NULL, 902, "Défendre ses choix."),
(NULL, 902, "Négocier une solution commune."),
(NULL, 902, "Organiser son travail dans le cadre d’un groupe."),
(NULL, 902, "Utiliser les outils numériques dans le travail collectif."),

(NULL, 903, "Les aires urbaines, une nouvelle géographie d’une France mondialisée."),
(NULL, 903, "Les espaces de faible densité et leurs atouts."),
(NULL, 903, "Les espaces productifs et leurs évolutions."),

(NULL, 904, "L’Union européenne, un nouveau territoire de référence et d’appartenance."),
(NULL, 904, "La France et l’Europe dans le monde."),

(NULL, 905, "Aménager pour répondre aux inégalités croissantes entre territoires français."),
(NULL, 905, "Les territoires ultra-marins français."),

(NULL, 906, "Civils et militaires dans la Première Guerre mondiale."),
(NULL, 906, "Démocraties fragilisées et expériences totalitaires dans l’Europe de l’entre-deux-guerres."),
(NULL, 906, "La Deuxième Guerre mondiale, une guerre d’anéantissement."),
(NULL, 906, "La France défaite et occupée. Régime de Vichy, collaboration, Résistance."),

(NULL, 907, "Indépendances et construction de nouveaux États."),

(NULL, 908, "1944-1947 : refonder la République, redéfinir la démocratie."),
(NULL, 908, "Femmes et hommes dans la société des années 1950 aux années 1980."),
(NULL, 908, "La Ve République, de la République gaullienne à l’alternance et à la cohabitation."),

(NULL, 909, "Un monde bipolaire au temps de la guerre froide."),

(NULL, 910, "Affirmation et mise en œuvre du projet européen."),

(NULL, 911, "Enjeux et conflits dans le monde après 1989."),

(NULL, 912, "Écrire pour structurer, argumenter et communiquer."),
(NULL, 912, "Réaliser des productions."),
(NULL, 912, "S’approprier et utiliser un lexique historique et géographique."),
(NULL, 912, "S’initier aux techniques d’argumentation."),

(NULL, 913, "Construire des hypothèses d’interprétation de phénomènes historiques ou géographiques."),
(NULL, 913, "Justifier."),
(NULL, 913, "Poser et se poser des questions à propos de situations historiques ou géographiques."),
(NULL, 913, "Vérifier."),

(NULL, 914, "Connaitre et utiliser différents systèmes d’information."),
(NULL, 914, "Exercer son esprit critique sur les données numériques."),
(NULL, 914, "Trouver, sélectionner et exploiter des informations dans une ressource numérique."),
(NULL, 914, "Utiliser des ressources numériques."),
(NULL, 914, "Vérifier l’origine, la source des informations et leur pertinence."),

(NULL, 915, "Nommer et localiser les grands repères géographiques."),
(NULL, 915, "Nommer, localiser et caractériser des espaces."),
(NULL, 915, "Nommer, localiser et caractériser un lieu."),
(NULL, 915, "Situer des lieux et des espaces."),
(NULL, 915, "Utiliser des représentations analogiques et numériques des espaces."),

(NULL, 916, "Identifier des continuités et des ruptures chronologiques."),
(NULL, 916, "Mettre en relation des faits."),
(NULL, 916, "Ordonner des faits les uns par rapport aux autres."),
(NULL, 916, "Situer un fait."),

-- 3EME - Langues vivantes

(NULL, 921, "niveau A1 - Identifier quelques grands repères culturels dans les pays ou régions étudiés."),
(NULL, 921, "niveau A2 - Mobiliser les connaissances culturelles acquises grâce au programme pour décrire des personnages réels ou imaginaires ou pour raconter des faits."),
(NULL, 921, "niveau A2 - Repérer les indices culturels pour comprendre un message."),
(NULL, 921, "niveau B1 - Repérer et comprendre les spécificités culturelles acquises des pays et des régions concernés et les mettre en lien avec sa culture personnelle."),

(NULL, 922, "niveau A1 - Comprendre des mots familiers et des expressions très courantes sur soi-même, sa famille et son environnement."),
(NULL, 922, "niveau A2 - Comprendre une intervention brève si elle est claire et simple."),
(NULL, 922, "niveau B1 - Comprendre les points essentiels d’un message sur un sujet connu exprimé dans une langue claire."),

(NULL, 923, "niveau A1 - Copier un modèle écrit, écrire un court message et renseigner un questionnaire simple."),
(NULL, 923, "niveau A2 - Écrire un texte court et articulé simplement."),
(NULL, 923, "niveau B1 - Rédiger un texte court et construit sur un sujet connu : reformuler, décrire, raconter, expliquer, exprimer son point de vue."),

(NULL, 924, "niveau A1 - Comprendre dans un message des mots familiers et des phrases très simples."),
(NULL, 924, "niveau A2 - Comprendre des textes courts et simples."),
(NULL, 924, "niveau B1 - Comprendre des textes rédigés dans une langue courante et renvoyant à un sujet connu."),

(NULL, 925, "niveau A1 - Avoir un contrôle limité de structures syntaxiques et de formes grammaticales simples appartenant à un répertoire mémorisé."),
(NULL, 925, "niveau A1 - La prononciation d’un répertoire limité d’expressions et de mots mémorisés est compréhensible avec quelque effort pour un locuteur natif."),
(NULL, 925, "niveau A1 - Utiliser des expressions et des phrases simples pour parler de soi et de son environnement immédiat."),
(NULL, 925, "niveau A2 - La prononciation est en général suffisamment claire pour être comprise malgré un net accent étranger."),
(NULL, 925, "niveau A2 - Se présenter brièvement, parler en termes simples de quelqu’un, d’une activité, d’un lieu."),
(NULL, 925, "niveau A2 - Utiliser correctement des structures simples mais commettre encore des erreurs élémentaires."),
(NULL, 925, "niveau B1 - Communiquer avec une correction suffisante. Des erreurs peuvent se produire mais le sens général reste clair."),
(NULL, 925, "niveau B1 - La prononciation est clairement intelligible même si les erreurs peuvent encore survenir occasionnellement."),
(NULL, 925, "niveau B1 - Prendre la parole sur des sujets connus pour reformuler, décrire, raconter, expliquer, exprimer un point de vue."),

(NULL, 926, "niveau A1 - Avoir un contrôle limité de structures syntaxiques et de formes grammaticales simples appartenant à un répertoire mémorisé."),
(NULL, 926, "niveau A1 - Communiquer, de façon simple, avec l’aide de l’interlocuteur."),
(NULL, 926, "niveau A1 - La prononciation d’un répertoire limité d’expressions et de mots mémorisés est compréhensible avec quelque effort pour un locuteur natif."),
(NULL, 926, "niveau A2 - Communiquer de façon simple."),
(NULL, 926, "niveau A2 - La prononciation est en général suffisamment claire pour être comprise malgré un net accent étranger."),
(NULL, 926, "niveau A2 - Utiliser correctement des strutures simples mais commettre encore des erreurs élémentaires."),
(NULL, 926, "niveau B1 - Communiquer avec une correction suffisante dans des contextes familiers. Des erreurs peuvent se produire mais le sens général reste clair."),
(NULL, 926, "niveau B1 - La prononciation est clairement intelligible même si des erreurs peuvent encore survenir occasionnellement."),
(NULL, 926, "niveau B1 - Prendre part spontanément à une conversation sur un sujet connu."),

-- 3EME - Mathématiques

(NULL, 931, "Écrire, mettre au point et exécuter un programme simple."),

(NULL, 932, "Représenter l’espace."),
(NULL, 932, "Utiliser des notions de géométrie plane pour démontrer."),

(NULL, 933, "Calculer avec des grandeurs mesurables ; exprimer les résultats dans les unités adaptées."),
(NULL, 933, "Comprendre l’effet de quelques transformations sur des grandeurs géométriques."),

(NULL, 934, "Comprendre et utiliser les notions de divisibilité et de nombres premiers."),
(NULL, 934, "Utiliser le calcul littéral."),
(NULL, 934, "Utiliser les nombres pour comparer, calculer et résoudre des problèmes."),

(NULL, 935, "Comprendre et utiliser des notions élémentaires de probabilités."),
(NULL, 935, "Comprendre et utiliser la notion de fonction."),
(NULL, 935, "Interpréter, représenter et traiter des données."),
(NULL, 935, "Résoudre des problèmes de proportionnalité."),

-- 3EME - Physique-chimie

(NULL, 941, "Adopter un comportement éthique et responsable."),
(NULL, 941, "Concevoir, créer, réaliser."),
(NULL, 941, "Mobiliser des outils numériques."),
(NULL, 941, "Pratiquer des démarches scientifiques."),
(NULL, 941, "Pratiquer des langages."),
(NULL, 941, "S’approprier des outils et des méthodes."),
(NULL, 941, "Se situer dans l’espace et le temps."),

(NULL, 942, "Identifier les sources, les transferts, les conversions et les formes d’énergie."),
(NULL, 942, "Réaliser des circuits électriques simples et exploiter les lois de l’électricité."),
(NULL, 942, "Utiliser la conservation de l’énergie."),

(NULL, 943, "Caractériser un mouvement."),
(NULL, 943, "Modéliser une interaction par une force caractérisée par un point d’application, une direction, un sens et une valeur."),

(NULL, 944, "Décrire et expliquer des transformations chimiques."),
(NULL, 944, "Décrire l’organisation de la matière dans l’Univers."),
(NULL, 944, "Décrire la constitution et les états de la matière."),

(NULL, 945, "Caractériser différents types de signaux (lumineux, sonores, radio…)."),
(NULL, 945, "Utiliser les propriétés de ces signaux."),

-- 3EME - Sciences de la vie et de la terre

(NULL, 951, "Adopter un comportement éthique et responsable."),
(NULL, 951, "Concevoir, créer, réaliser."),
(NULL, 951, "Mobiliser des outils numériques."),
(NULL, 951, "Pratiquer des démarches scientifiques et technologiques."),
(NULL, 951, "Pratiquer des langages."),
(NULL, 951, "S’approprier des outils et des méthodes."),
(NULL, 951, "Se situer dans l’espace et le temps."),

(NULL, 952, "Envisager ou justifier des comportements responsables face à l’environnement et à la préservation des ressources limitées de la planète."),
(NULL, 952, "Explorer et expliciter certains éléments de météorologie et climatologie."),
(NULL, 952, "Explorer et expliciter certains phénomènes géologiques liés au fonctionnement de la Terre."),
(NULL, 952, "Identifier les principaux impacts de l’action humaine, bénéfices et risques, à la surface de la planète Terre."),

(NULL, 953, "Expliquer quelques processus biologiques impliqués dans le fonctionnement de l’organisme humain, jusqu’au niveau moléculaire : activités musculaire, nerveuse et cardio-vasculaire, activité cérébrale, alimentation et digestion, relations avec le monde microbien, reproduction et sexualité."),
(NULL, 953, "Relier la connaissance de ces processus biologiques aux enjeux liés aux comportements responsables individuels et collectifs en matière de santé."),

(NULL, 954, "Expliquer l’organisation du monde vivant, sa structure et son dynamisme à différentes échelles d’espace et de temps."),
(NULL, 954, "Mettre en relation différents faits et établir des relations de causalité pour expliquer : la nutrition des organismes, la dynamique des populations, la classification du vivant, la biodiversité, la diversité génétique des individus, l’évolution des êtres vivants."),

-- 3EME - Technologie

(NULL, 961, "Concevoir, créer, réaliser."),
(NULL, 961, "Mobiliser les outils numériques."),
(NULL, 961, "Pratiquer des démarches scientifiques et technologiques."),
(NULL, 961, "Pratiquer des langages."),
(NULL, 961, "S’approprier les outils et les méthodes."),
(NULL, 961, "Se situer dans l’espace et le temps."),

(NULL, 962, "Imaginer des solutions, matérialiser des idées."),
(NULL, 962, "Réaliser un prototype."),

(NULL, 963, "Écrire, mettre au point et exécuter un programme."),
(NULL, 963, "Fonctionnement d’un réseau informatique."),

(NULL, 964, "Fonctionnement et structure d’un objet."),
(NULL, 964, "Utiliser une modélisation, simulation des objets."),

(NULL, 965, "Évolution des objets et systèmes."),
(NULL, 965, "Objets communicants et bonnes pratiques."),
(NULL, 965, "Outils de description.");

ALTER TABLE sacoche_livret_element_item ENABLE KEYS;
