<?php
/**
 * @version $Id$
 * @author Thomas Crespin <thomas.crespin@sesamath.net>
 * @copyright Thomas Crespin 2009-2022
 * 
 * ****************************************************************************************************
 * SACoche <https://sacoche.sesamath.net> - Suivi d’Acquisitions de Compétences
 * © Thomas Crespin pour Sésamath <https://www.sesamath.net> - Tous droits réservés.
 * Logiciel placé sous la licence libre Affero GPL 3 <https://www.gnu.org/licenses/agpl-3.0.html>.
 * ****************************************************************************************************
 * 
 * Ce fichier est une partie de SACoche.
 * 
 * SACoche est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes 
 * de la “GNU Affero General Public License” telle que publiée par la Free Software Foundation :
 * soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.
 * 
 * SACoche est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE :
 * sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.
 * Consultez la Licence Publique Générale GNU Affero pour plus de détails.
 * 
 * Vous devriez avoir reçu une copie de la Licence Publique Générale GNU Affero avec SACoche ;
 * si ce n’est pas le cas, consultez : <http://www.gnu.org/licenses/>.
 * 
 */

if(!defined('SACoche')) {exit('Ce fichier ne peut être appelé directement !');}
$TITRE = html(Lang::_('Livret Scolaire')).' &rarr; '.html(Lang::_('Formations en 3e'));

if( ($_SESSION['USER_PROFIL_TYPE']!='directeur') && ($_SESSION['USER_PROFIL_TYPE']!='administrateur') )
{
  echo'<p class="danger">'.html(Lang::_('Vous n’êtes pas habilité à accéder à cette fonctionnalité !')).'</p>'.NL;
  echo'<div class="astuce">Seuils les administrateurs et les personnels de direction peuvent consulter cette page.</div>'.NL;
  return; // Ne pas exécuter la suite de ce fichier inclus.
}

$choix = Clean::get('choix', 'id', '');

// On complète le Sous-Menu d’en-tête
$tab_choix = array(
  'formations'    => 'Voir les formations des élèves',
  'enseignements' => 'Voir les enseignements attendus par formation',
);
$SOUS_MENU = !empty($SOUS_MENU) ? $SOUS_MENU.'<hr>' : '' ; // n’est pas défini si appel de la forme ?page=livret_xxx au lieu de ?page=livret&section=xxx
foreach($tab_choix as $key => $titre)
{
  $class = ($key==$choix) ? ' class="actif"' : '' ;
  $SOUS_MENU .= '<a'.$class.' href="./index.php?page=livret&amp;section=mef3emes&amp;choix='.$key.'">'.$titre.'</a>'.NL;
  // On complète le titre de la page
  if($key==$choix)
  {
    $TITRE .= ' &rarr; '.html($titre);
  }
}
?>

<ul class="puce">
  <li><span class="manuel"><a class="pop_up" href="<?php echo SERVEUR_DOCUMENTAIRE ?>?fichier=officiel__livret_scolaire_administration#toggle_mef3emes">DOC : Administration du Livret Scolaire &rarr; Formations en 3e</a></span></li>
  <li><span class="astuce">Ce menu ne sert que pour les <b>bilans périodiques</b> des <b>élèves de 3e</b>.</span></li>
  <li><label class="alerte">Dans le cas de formations déclinées ou académiques <?php echo infobulle('3e sport études'.BRJS.'3e ULIS'.BRJS.'3e UPE2A'.BRJS.'3e cinéma-audiovisuel'.BRJS.'...',TRUE) ?>, c’est la formation nationale de rattachement qui est considérée.</label></li>
  <li><span class="danger">En cas d'erreur, pour les établissements sous <em>Siècle</em>, modifier dans <em>Siècle</em> puis réimporter depuis <em>Siècle</em>.<br>Dans ce cas ce menu sert seulement à consulter / vérifier les niveaux de formation et ne doit pas être utilisé pour les modifier.</span></li>
</ul>

<hr>

<?php

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Voir les formations des élèves
// ////////////////////////////////////////////////////////////////////////////////////////////////////

if($choix=='formations')
{

  $alerte = '';
  //  Vérifier que les classes de 3e comportent des élèves avec une MEF 3e
  $DB_TAB = DB_STRUCTURE_LIVRET::DB_lister_classes_3e_avec_eleve_sans_mef_3e();
  if(!empty($DB_TAB))
  {
    $affichage_anomalies = '';
    foreach($DB_TAB as $DB_ROW)
    {
      $s = ($DB_ROW['nombre']>1) ? 's' : '' ;
      $affichage_anomalies .= html($DB_ROW['groupe_nom'].' ('.$DB_ROW['nombre']).' élève'.$s.') ';
    }
    $alerte .= 'Des classes associées au niveau 3e du Livret Scolaire comportent des élèves hors formation de 3e !<br>'.$affichage_anomalies.'<br>'.NL;
  }
  //  Vérifier que des élèves avec une MEF 3e sont bien dans les classes de 3e
  $DB_TAB = DB_STRUCTURE_LIVRET::DB_lister_eleve_mef_3e_hors_classe_3e();
  if(!empty($DB_TAB))
  {
    $affichage_anomalies = '';
    foreach($DB_TAB as $DB_ROW)
    {
      $s = ($DB_ROW['nombre']>1) ? 's' : '' ;
      $affichage_anomalies .= html($DB_ROW['groupe_nom'].' ('.$DB_ROW['nombre']).' élève'.$s.') ';
    }
    $alerte .= 'Des élèves en formation de 3e ne sont pas dans une classe associée au niveau 3e du Livret Scolaire !<br>'.$affichage_anomalies.'<br>'.NL;
  }
  if($alerte)
  {
    echo'<p class="danger">'.$alerte.'Rectifiez dans <em>Siècle</em> puis réimportez les élèves, ou renseignez ci-dessous si hors <em>Siècle</em>, ou vérifiez les associations à l’étape n°1 "Classes / Périodicité" ci-dessus.</p>'.NL;
  }

  // Fabrication des éléments select du formulaire
  $select_eleve  = HtmlForm::afficher_select(DB_STRUCTURE_COMMUN::DB_OPT_regroupements_etabl(), 'select_groupe' /*select_nom*/ ,            '' /*option_first*/ , FALSE /*selection*/ , 'regroupements' /*optgroup*/ );
  $select_mef_3e = HtmlForm::afficher_select(DB_STRUCTURE_COMMUN::DB_OPT_mef_3e()             , 'f_mef3e'       /*select_nom*/ , 'sans_mef_3e' /*option_first*/ , FALSE /*selection*/ ,              '' /*optgroup*/ );

  echo'
  <form action="#" method="post" id="form_select">
    <table><tr>
      <td class="nu" style="width:25em;vertical-align:top">
        <b>Élèves :</b><br>
        '.$select_eleve.'<br>
        <span id="ajax_eleves"></span>
      </td>
      <td class="nu" style="width:25em;vertical-align:top">
        <p><b>Formation :</b> '.$select_mef_3e.'</p>
        <p><button id="bouton_associer" type="button" class="parametre">Effectuer ces associations.</button></p>
        <p><label id="ajax_msg">&nbsp;</label></p>
      </td>
    </tr></table>
  </form>
  ';
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Voir les enseignements attendus par formation
// ////////////////////////////////////////////////////////////////////////////////////////////////////

else if($choix=='enseignements')
{
  $DB_TAB = DB_STRUCTURE_LIVRET::DB_lister_matieres_mef_3e();
  if(empty($DB_TAB))
  {
    echo'<p class="astuce">Aucun niveau de formation 3e n’est suivi par les élèves.</p>'.NL;
  }
  else
  {
    echo'<p class="astuce">Seules les formations dispensées dans l’établissement sont listées.</p>'.NL;
    $tab_mef = array();
    $tab_categorie = array( 1 => 'enseignements obligatoires' , 0 => 'enseignements optionnels' );
    $tab_enseignement = array();
    $tab_jointure = array();
    foreach($DB_TAB as $DB_ROW)
    {
      $tab_mef[$DB_ROW['livret_dnb_mef_id']] = $DB_ROW['livret_dnb_mef_intitule'];
      $tab_enseignement[$DB_ROW['livret_dnb_matiere_obligatoire']][$DB_ROW['livret_dnb_matiere_code']] = $DB_ROW['livret_dnb_matiere_nom'];
      $tab_jointure[$DB_ROW['livret_dnb_mef_id']][$DB_ROW['livret_dnb_matiere_obligatoire']][$DB_ROW['livret_dnb_matiere_code']] = TRUE;
    }
    echo'<table><thead><tr><td class="nu">';
    foreach($tab_mef as $mef_intitule)
    {
      echo'<th class="wpn">'.html($mef_intitule).'</th>';
    }
    echo'</tr></thead><tbody>';
    foreach($tab_categorie as $categorie_id => $categorie_intitule)
    {
      $first = TRUE;
      foreach($tab_enseignement[$categorie_id] as $matiere_code => $matiere_nom)
      {
        echo'<tr>';
        if($first)
        {
          echo'<th class="wpn" rowspan="'.count($tab_enseignement[$categorie_id]).'">'.html($categorie_intitule).'</th>';
          $first = FALSE;
        }
        foreach($tab_mef as $mef_id => $mef_intitule)
        {
          if(!empty($tab_jointure[$mef_id][$categorie_id][$matiere_code]))
          {
            echo'<td class="wpn">'.html($matiere_nom).'</td>';
          }
          else
          {
            echo'<td class="nu"></td>';
          }
        }
        echo'</tr>';
      }
    }
    echo'</tbody><table>';
  }
}

// ////////////////////////////////////////////////////////////////////////////////////////////////////
// Sommaire
// ////////////////////////////////////////////////////////////////////////////////////////////////////

else
{
  echo'<p class="astuce">Choisir un des deux sous-menus :</p>'.NL;
  echo'<ul class="puce">'.NL;
  foreach($tab_choix as $key => $titre)
  {
    echo'<li class="p"><a href="./index.php?page=livret&amp;section=mef3emes&amp;choix='.$key.'">'.$titre.'</a></li>'.NL;
  }
  echo'</ul>'.NL;
}

?>
<hr>

<div id="bilan">
</div>
