/**
 * @version $Id$
 * @author Thomas Crespin <thomas.crespin@sesamath.net>
 * @copyright Thomas Crespin 2009-2022
 * 
 * ****************************************************************************************************
 * SACoche <http://sacoche.sesamath.net> - Suivi d’Acquisitions de Compétences
 * © Thomas Crespin pour Sésamath <http://www.sesamath.net> - Tous droits réservés.
 * Logiciel placé sous la licence libre Affero GPL 3 <https://www.gnu.org/licenses/agpl-3.0.html>.
 * ****************************************************************************************************
 * 
 * Ce fichier est une partie de SACoche.
 * 
 * SACoche est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes 
 * de la “GNU Affero General Public License” telle que publiée par la Free Software Foundation :
 * soit la version 3 de cette licence, soit (à votre gré) toute version ultérieure.
 * 
 * SACoche est distribué dans l’espoir qu’il vous sera utile, mais SANS AUCUNE GARANTIE :
 * sans même la garantie implicite de COMMERCIALISABILITÉ ni d’ADÉQUATION À UN OBJECTIF PARTICULIER.
 * Consultez la Licence Publique Générale GNU Affero pour plus de détails.
 * 
 * Vous devriez avoir reçu une copie de la Licence Publique Générale GNU Affero avec SACoche ;
 * si ce n’est pas le cas, consultez : <http://www.gnu.org/licenses/>.
 * 
 */

// Activer le mode strict afin de tendre vers un code rigoureux
'use strict';

// jQuery !
$(document).ready
(
  function()
  {

    // ////////////////////////////////////////////////////////////////////////////////////////////////////
    // Choix d’une zone géographique : charger les établissements correspondants
    // ////////////////////////////////////////////////////////////////////////////////////////////////////

    $('#f_geo_id').change
    (
      function()
      {
        $('#ajax_retour').html('');
        $('#f_base').html('<option>&nbsp;</option>').hide();
        var geo_id = $('#f_geo_id option:selected').val();
        if( !geo_id )
        {
          $('#ajax_msg').attr('class','erreur').html('Choisir une zone !');
          return false;
        }
        else
        {
          $('#ajax_msg').attr('class','loader').html('En cours&hellip;');
          $.ajax
          (
            {
              type : 'POST',
              url : 'ajax.php?page=_maj_select_structures',
              data : 'f_geo_id='+geo_id,
              dataType : 'json',
              error : function(jqXHR, textStatus, errorThrown)
              {
                $('#ajax_msg').attr('class','alerte').html(afficher_json_message_erreur(jqXHR,textStatus));
              },
              success : function(responseJSON)
              {
                initialiser_compteur();
                if(responseJSON['statut']==true)
                {
                  $('#ajax_msg').removeAttr('class').html('');
                  $('#f_base').html(responseJSON['value']).show();
                }
                else
                {
                  $('#ajax_msg').attr('class','alerte').html(responseJSON['value']);
                }
              }
            }
          );
        }
      }
    );

    // ////////////////////////////////////////////////////////////////////////////////////////////////////
    // Choix d’un établissement : charger les données correspondantes
    // ////////////////////////////////////////////////////////////////////////////////////////////////////

    $('#f_base').change
    (
      function()
      {
        $('#ajax_retour').html('');
        var base_id = $('#f_base option:selected').val();
        if( !base_id )
        {
          $('#ajax_msg').attr('class','erreur').html('Choisir un établissement !');
          return false;
        }
        else
        {
          $('#ajax_msg').attr('class','loader').html('En cours&hellip;');
          $.ajax
          (
            {
              type : 'POST',
              url : 'ajax.php?page='+window.PAGE,
              data : 'csrf='+window.CSRF+'&f_base_id='+base_id,
              dataType : 'json',
              error : function(jqXHR, textStatus, errorThrown)
              {
                $('#ajax_msg').attr('class','alerte').html(afficher_json_message_erreur(jqXHR,textStatus));
                return false;
              },
              success : function(responseJSON)
              {
                initialiser_compteur();
                if(responseJSON['statut']==false)
                {
                  $('#ajax_msg').attr('class','alerte').html(responseJSON['value']);
                }
                else
                {
                  $('#ajax_msg').attr('class','valide').html('Voir ci-dessous.');
                  $('#ajax_retour').html(responseJSON['value']);
                }
              }
            }
          );
        }
      }
    );

  }
);
